/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.util;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.jql.parser.JqlParseException;
import com.atlassian.jira.jql.parser.JqlQueryParser;
import com.atlassian.jira.jql.util.ArgumentExtractingOperandVisitor;
import com.atlassian.jira.jql.util.JqlCustomFieldId;
import com.atlassian.jira.jql.util.JqlQueryTransformer;
import com.atlassian.jira.jql.util.RecursiveClauseMappingVisitor;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.OrClause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operand.MultiValueOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.OperandVisitor;
import com.atlassian.query.operand.SingleValueOperand;
import com.atlassian.query.order.OrderBy;
import com.atlassian.query.order.OrderByImpl;
import com.atlassian.query.order.SearchSort;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DefaultJqlQueryTransformer
implements JqlQueryTransformer {
    private static final Set<String> ISSUE_TYPE_FIELD_NAMES = Sets.newHashSet((Object[])new String[]{"type", "issuetype"});
    private final CustomFieldManager customFieldManager;
    private final ConstantsManager constantsManager;
    private final JqlQueryParser jqlQueryParser;
    private final FieldManager fieldManager;

    public DefaultJqlQueryTransformer(CustomFieldManager customFieldManager, ConstantsManager constantsManager, JqlQueryParser jqlQueryParser, FieldManager fieldManager) {
        this.customFieldManager = customFieldManager;
        this.constantsManager = constantsManager;
        this.jqlQueryParser = jqlQueryParser;
        this.fieldManager = fieldManager;
    }

    public Query transformNamesToIds(Query query) {
        return this.transformQuery(query, this::findCustomFieldIds, this::findIssueTypeId);
    }

    public Query transformNamesToIds(String query) throws JqlParseException {
        Query parsedQuery = this.jqlQueryParser.parseQuery(query);
        return this.transformNamesToIds(parsedQuery);
    }

    public Query transformIdsToNames(Query query) {
        return this.transformQuery(query, this::findUnambiguousCustomFieldName, this::findIssueTypeName);
    }

    public Query transformIdsToNames(String query) throws JqlParseException {
        Query parsedQuery = this.jqlQueryParser.parseQuery(query);
        return this.transformIdsToNames(parsedQuery);
    }

    private Query transformQuery(Query query, Function<String, Collection<String>> customFieldMapper, Function<String, Optional<String>> issueTypeMapper) {
        Clause originalWhereClause = query.getWhereClause();
        Clause transformedWhereClause = Optional.ofNullable(originalWhereClause).map(clause -> (Clause)clause.accept((ClauseVisitor)new CustomFieldsAndIssueTypesReplacingVisitor(customFieldMapper, issueTypeMapper))).orElse(originalWhereClause);
        OrderBy orderByClause = query.getOrderByClause();
        OrderBy transformedOrderBy = Optional.ofNullable(orderByClause).map(orderBy -> this.transformOrderBy((OrderBy)orderBy, customFieldMapper)).orElse(orderByClause);
        return new QueryImpl(transformedWhereClause, transformedOrderBy, query.getQueryString());
    }

    private OrderBy transformOrderBy(OrderBy orderByClause, Function<String, Collection<String>> customFieldMapper) {
        Collection transformedSearchSort = orderByClause.getSearchSorts().stream().flatMap(searchSort -> this.replaceCustomFieldNameInSearchSort((SearchSort)searchSort, customFieldMapper).stream()).collect(Collectors.toList());
        return new OrderByImpl(transformedSearchSort);
    }

    private Collection<SearchSort> replaceCustomFieldNameInSearchSort(SearchSort searchSort, Function<String, Collection<String>> customFieldMapper) {
        String fieldName = searchSort.getField();
        Collection<String> fieldReplacements = customFieldMapper.apply(fieldName);
        return fieldReplacements.stream().map(searchSortField -> this.replaceSearchSortField(searchSort, (String)searchSortField)).collect(Collectors.collectingAndThen(Collectors.toList(), searchSorts -> {
            if (searchSorts.isEmpty()) {
                return Collections.singletonList(searchSort);
            }
            return searchSorts;
        }));
    }

    private SearchSort replaceSearchSortField(SearchSort searchSort, String searchSortField) {
        return new SearchSort(searchSortField, searchSort.getProperty(), searchSort.getSortOrder());
    }

    private Collection<String> findCustomFieldIds(String customFieldName) {
        if (this.isSystemFieldName(customFieldName)) {
            return Collections.emptyList();
        }
        return this.customFieldManager.getCustomFieldObjectsByNameIgnoreCase(customFieldName).stream().map(cf -> JqlCustomFieldId.toString((long)cf.getIdAsLong())).collect(Collectors.toList());
    }

    private Collection<String> findUnambiguousCustomFieldName(String customFieldId) {
        if (!JqlCustomFieldId.isJqlCustomFieldId((String)customFieldId)) {
            return Collections.emptyList();
        }
        long fieldId = JqlCustomFieldId.parseId((String)customFieldId);
        CustomField customField = this.customFieldManager.getCustomFieldObject(Long.valueOf(fieldId));
        if (customField != null && this.isCustomFieldNameUnambiguous(customField)) {
            return Collections.singletonList(customField.getName());
        }
        return Collections.emptyList();
    }

    private boolean isCustomFieldNameUnambiguous(CustomField customField) {
        Collection customFields = this.customFieldManager.getCustomFieldObjectsByNameIgnoreCase(customField.getFieldName());
        if (customFields.size() == 1) {
            String cfName = ((CustomField)customFields.iterator().next()).getName();
            return !this.isSystemFieldName(cfName);
        }
        return false;
    }

    private boolean isSystemFieldName(String customFieldName) {
        return this.fieldManager.getSystemSearchableFields().stream().map(Field::getName).anyMatch(customFieldName::equalsIgnoreCase);
    }

    private Optional<String> findIssueTypeId(String issueTypeName) {
        String issueType = ConstantsManager.CONSTANT_TYPE.ISSUE_TYPE.getType();
        return Optional.ofNullable(this.constantsManager.getConstantByNameIgnoreCase(issueType, issueTypeName)).map(IssueConstant::getId);
    }

    private Optional<String> findIssueTypeName(String issueTypeId) {
        String issueType = ConstantsManager.CONSTANT_TYPE.ISSUE_TYPE.getType();
        return Optional.ofNullable(this.constantsManager.getConstantObject(issueType, issueTypeId)).map(IssueConstant::getName);
    }

    private static class CustomFieldsAndIssueTypesReplacingVisitor
    extends RecursiveClauseMappingVisitor {
        private final Function<String, Collection<String>> customFieldMapper;
        private final Function<String, Optional<String>> issueTypeMapper;
        private final ArgumentExtractingOperandVisitor argumentExtractingOperandVisitor;

        private CustomFieldsAndIssueTypesReplacingVisitor(Function<String, Collection<String>> customFieldMapper, Function<String, Optional<String>> issueTypeMapper) {
            this.customFieldMapper = customFieldMapper;
            this.issueTypeMapper = issueTypeMapper;
            this.argumentExtractingOperandVisitor = new ArgumentExtractingOperandVisitor();
        }

        public Clause visit(TerminalClause clause) {
            if (this.isIssueTypeFieldName(clause.getName())) {
                return this.replaceIssueType(clause);
            }
            return this.replaceCustomField(clause);
        }

        private Clause replaceCustomField(TerminalClause originalClause) {
            Collection<String> customFieldReplacements = this.customFieldMapper.apply(originalClause.getName());
            return customFieldReplacements.stream().map(replacement -> this.replaceClauseName(originalClause, (String)replacement)).collect(Collectors.collectingAndThen(Collectors.toList(), clauses -> {
                if (clauses.isEmpty()) {
                    return originalClause;
                }
                if (clauses.size() == 1) {
                    return (Clause)clauses.get(0);
                }
                return new OrClause((Collection)clauses);
            }));
        }

        private TerminalClauseImpl replaceClauseName(TerminalClause clause, String replacement) {
            return new TerminalClauseImpl(replacement, clause.getOperator(), clause.getOperand(), clause.getProperty());
        }

        private Clause replaceIssueType(TerminalClause originalClause) {
            List issueTypes = (List)originalClause.getOperand().accept((OperandVisitor)this.argumentExtractingOperandVisitor);
            List<String> issueTypesMapping = issueTypes.stream().map(issueTypeName -> this.issueTypeMapper.apply((String)issueTypeName).orElse((String)issueTypeName)).collect(Collectors.toList());
            if (originalClause.getOperand() instanceof SingleValueOperand) {
                return this.replaceClauseOperand(originalClause, (Operand)new SingleValueOperand((String)issueTypesMapping.get(0)));
            }
            if (originalClause.getOperand() instanceof MultiValueOperand) {
                return this.replaceClauseOperand(originalClause, (Operand)new MultiValueOperand(issueTypesMapping.toArray(new String[0])));
            }
            return originalClause;
        }

        private TerminalClauseImpl replaceClauseOperand(TerminalClause originalClause, Operand replacement) {
            return new TerminalClauseImpl(originalClause.getName(), originalClause.getOperator(), replacement, originalClause.getProperty());
        }

        private boolean isIssueTypeFieldName(String clauseName) {
            return ISSUE_TYPE_FIELD_NAMES.stream().anyMatch(name -> name.contains(clauseName));
        }
    }
}

