/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ofbiz;

import com.atlassian.jira.ofbiz.DatabaseField;
import com.atlassian.jira.ofbiz.MissingFieldException;
import com.atlassian.jira.ofbiz.MissingTableException;
import com.atlassian.jira.ofbiz.UnsupportedTypeException;
import com.atlassian.jira.util.Functions;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;

class FieldSupportValidator {
    private final LoadingCache<DatabaseField, Support> map;
    private final String name;

    FieldSupportValidator(String name, Collection<String> unsupportedTypes, com.atlassian.jira.util.Function<String, com.atlassian.jira.util.Function<String, String>> fieldResolver) {
        this(name, new Resolver(unsupportedTypes, fieldResolver));
    }

    FieldSupportValidator(String name, Resolver supportResolver) {
        this.map = CacheBuilder.newBuilder().build(CacheLoader.from((Function)Functions.toGoogleFunction((com.atlassian.jira.util.Function)supportResolver)));
        this.name = name;
    }

    void checkAll(String table, Iterable<String> fields) {
        for (String field : fields) {
            this.check(table, field);
        }
    }

    void check(String table, String field) {
        DatabaseField key = new DatabaseField(table, field);
        Support support = (Support)((Object)this.map.getUnchecked((Object)key));
        if (support != null) {
            support.check(this.name, key);
        }
    }

    static class Resolver
    implements com.atlassian.jira.util.Function<DatabaseField, Support> {
        private final Set<String> unsupportedTypes;
        private final com.atlassian.jira.util.Function<String, com.atlassian.jira.util.Function<String, String>> fieldTypeResolver;

        public Resolver(Collection<String> unsupportedTypes, com.atlassian.jira.util.Function<String, com.atlassian.jira.util.Function<String, String>> fieldTypeResolver) {
            this.unsupportedTypes = CollectionBuilder.newBuilder().addAll(unsupportedTypes).asSet();
            this.fieldTypeResolver = (com.atlassian.jira.util.Function)Assertions.notNull((String)"fieldTypeResolver", fieldTypeResolver);
        }

        public Support apply(@Nonnull DatabaseField input) {
            com.atlassian.jira.util.Function entity = (com.atlassian.jira.util.Function)this.fieldTypeResolver.apply((Object)input.table());
            if (entity == null) {
                return Support.MISSING_TABLE;
            }
            String fieldType = (String)entity.apply((Object)input.field());
            if (fieldType == null) {
                return Support.MISSING_FIELD;
            }
            if (this.unsupportedTypes.contains(fieldType)) {
                return Support.UNSUPPORTED_TYPE;
            }
            return Support.SUPPORTED;
        }
    }

    static enum Support {
        SUPPORTED{

            @Override
            void check(String name, DatabaseField field) {
            }
        }
        ,
        UNSUPPORTED_TYPE{

            @Override
            void check(String name, DatabaseField field) {
                throw new UnsupportedTypeException(name, field);
            }
        }
        ,
        MISSING_TABLE{

            @Override
            void check(String name, DatabaseField field) {
                throw new MissingTableException(name, field);
            }
        }
        ,
        MISSING_FIELD{

            @Override
            void check(String name, DatabaseField field) {
                throw new MissingFieldException(name, field);
            }
        };


        abstract void check(String var1, DatabaseField var2);
    }
}

