/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ofbiz.sql;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.diagnostic.connection.DatabaseDiagnosticsCollectorDelegate;
import com.atlassian.jira.diagnostic.connection.DiagnosticConnection;
import com.atlassian.jira.ofbiz.sql.TransactionFactoryInterfaceWrapper;
import java.sql.Connection;
import java.sql.SQLException;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.transaction.JNDIFactory;
import org.ofbiz.core.entity.transaction.TransactionFactoryInterface;

public class JiraSupportedDatabasesCompatibleJNDIFactory
extends TransactionFactoryInterfaceWrapper {
    private DatabaseDiagnosticsCollectorDelegate diagnosticsCollector;

    public JiraSupportedDatabasesCompatibleJNDIFactory() {
        super((TransactionFactoryInterface)new JNDIFactory());
    }

    @Override
    public Connection getConnection(String s) throws SQLException, GenericEntityException {
        return this.wrapForDiagnostics(super.getConnection(s));
    }

    private Connection wrapForDiagnostics(Connection connection) {
        if (this.diagnosticsCollector == null) {
            this.diagnosticsCollector = this.diagnosticsCollector();
        }
        if (this.diagnosticsCollector != null && this.diagnosticsCollector.isEnabled()) {
            DiagnosticConnection diagnosticConnection = new DiagnosticConnection(connection, this.diagnosticsCollector);
            this.diagnosticsCollector.trackConnection(diagnosticConnection);
            return diagnosticConnection;
        }
        return connection;
    }

    private DatabaseDiagnosticsCollectorDelegate diagnosticsCollector() {
        try {
            return (DatabaseDiagnosticsCollectorDelegate)ComponentAccessor.getComponent(DatabaseDiagnosticsCollectorDelegate.class);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }
}

