/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.attachment;

import com.atlassian.jira.issue.attachment.MimetypesFileTypeMap;
import com.atlassian.jira.plugin.attachment.AttachmentArchiveEntry;
import com.atlassian.jira.plugin.attachment.AttachmentArchiveEntryBuilder;
import com.atlassian.jira.plugin.attachment.AttachmentProcessor;
import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipAttachmentProcessor
implements AttachmentProcessor {
    private static final Logger log = LoggerFactory.getLogger(ZipAttachmentProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AttachmentArchiveEntry> processAttachment(@Nonnull File file) {
        ImmutableList immutableList;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            Enumeration enumeration = zipFile.getEntries();
            ImmutableList.Builder builder = ImmutableList.builder();
            int index = 0;
            int countNoDirectory = 0;
            while (enumeration.hasMoreElements() && countNoDirectory < 100) {
                ZipArchiveEntry zipEntry = (ZipArchiveEntry)enumeration.nextElement();
                if (!zipEntry.isDirectory()) {
                    String name = zipEntry.getName();
                    String mediaType = MimetypesFileTypeMap.getContentType(name);
                    AttachmentArchiveEntry entry = new AttachmentArchiveEntryBuilder().entryIndex(index).name(name).size(zipEntry.getSize()).mediaType(mediaType).build();
                    builder.add((Object)entry);
                    ++countNoDirectory;
                }
                ++index;
            }
            immutableList = builder.build();
        }
        catch (IOException e) {
            List<AttachmentArchiveEntry> list;
            try {
                log.warn("Something went wrong while processing attachment's stream. Probably the attachment is not a zip file");
                list = Collections.emptyList();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zipFile);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)zipFile);
            return list;
        }
        IOUtils.closeQuietly((Closeable)zipFile);
        return immutableList;
    }
}

