/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.icon;

import com.atlassian.jira.icon.IconType;
import com.atlassian.jira.plugin.icon.IconTypeDefinition;
import com.atlassian.jira.plugin.icon.IconTypeDefinitionFactory;
import com.atlassian.jira.plugin.icon.IconTypeModuleDescriptor;
import com.atlassian.ozymandias.PluginPointVisitor;
import com.atlassian.ozymandias.SafeAccessViaPluginAccessor;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.PluginAccessor;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IconTypeDefinitionFactoryImpl
implements IconTypeDefinitionFactory {
    private static final Logger log = LoggerFactory.getLogger(IconTypeDefinitionFactoryImpl.class);
    private PluginAccessor pluginAccessor;

    public IconTypeDefinitionFactoryImpl(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    private IconTypeNameCollector collectIconTypes() {
        IconTypeNameCollector collector = new IconTypeNameCollector();
        SafeAccessViaPluginAccessor safe = SafePluginPointAccess.to((PluginAccessor)this.pluginAccessor);
        safe.forType(IconTypeModuleDescriptor.class, (PluginPointVisitor)collector);
        return collector;
    }

    @Override
    public IconTypeDefinition getDefinition(IconType iconType) {
        return this.collectIconTypes().getDefinition(iconType);
    }

    @Override
    @Nonnull
    public String getDefaultSystemIconFilename(IconType iconType) {
        IconTypeModuleDescriptor moduleDescriptor = this.collectIconTypes().getModule(iconType);
        if (moduleDescriptor == null) {
            throw new IllegalArgumentException("Unknown icon type '" + iconType + "'");
        }
        return moduleDescriptor.getDefaultFilename();
    }

    public class IconTypeNameCollector
    implements PluginPointVisitor<IconTypeModuleDescriptor, IconTypeDefinition> {
        private Map<String, IconTypeDefinition> nameToDefinitionMap = new HashMap<String, IconTypeDefinition>();
        private Map<String, IconTypeModuleDescriptor> nameToModuleMap = new HashMap<String, IconTypeModuleDescriptor>();

        public void visit(IconTypeModuleDescriptor moduleDescriptor, IconTypeDefinition module) {
            if (module.getKey() == null) {
                log.warn("IconType class " + module.getClass().getName() + " supplied a null name. This IconType will be ignored");
            } else if (this.nameToDefinitionMap.containsKey(module.getKey())) {
                log.warn("IconType calss " + module.getClass().getName() + " supplied a key (" + module.getKey() + ") that is already used by the IconType " + this.nameToDefinitionMap.get(module.getKey()).getClass().getName() + ". This IconType will be ignored");
            } else {
                this.nameToDefinitionMap.put(module.getKey(), module);
                this.nameToModuleMap.put(module.getKey(), moduleDescriptor);
            }
        }

        public IconTypeDefinition getDefinition(IconType iconType) {
            return this.nameToDefinitionMap.get(iconType.getKey());
        }

        public IconTypeModuleDescriptor getModule(IconType iconType) {
            return this.nameToModuleMap.get(iconType.getKey());
        }
    }
}

