/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issuetabpanel;

import com.atlassian.jira.plugin.issuetabpanel.DefaultPage;
import com.atlassian.jira.plugin.issuetabpanel.GetActionsRequest;
import com.atlassian.jira.plugin.issuetabpanel.IssueAction;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelInvoker;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelModuleDescriptor;
import com.atlassian.jira.plugin.issuetabpanel.Page;
import com.atlassian.jira.plugin.issuetabpanel.PaginatedIssueTabPanel;
import com.atlassian.jira.plugin.issuetabpanel.ShowPanelRequest;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.ozymandias.SafePluginPointAccess;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IssueTabPanelInvokerImpl
implements IssueTabPanelInvoker {
    private static final Logger log = LoggerFactory.getLogger(IssueTabPanelInvokerImpl.class);
    private final I18nHelper.BeanFactory i18Factory;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public IssueTabPanelInvokerImpl(I18nHelper.BeanFactory i18Factory, JiraAuthenticationContext jiraAuthenticationContext) {
        this.i18Factory = i18Factory;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Override
    public boolean invokeShowPanel(ShowPanelRequest request, IssueTabPanelModuleDescriptor descriptor) {
        Option showPanel = SafePluginPointAccess.call(() -> ((PaginatedIssueTabPanel)descriptor.getModule()).showPanel(request));
        if (showPanel.isEmpty()) {
            log.error("Exception thrown while trying to call showPanel() for {}", (Object)descriptor);
            return true;
        }
        return (Boolean)showPanel.get();
    }

    @Override
    public Page<IssueAction> invokeGetActions(GetActionsRequest request, IssueTabPanelModuleDescriptor descriptor) {
        Option actions = SafePluginPointAccess.call(() -> ((PaginatedIssueTabPanel)descriptor.getModule()).getActions(request));
        if (actions.isEmpty()) {
            log.error("Exception thrown while trying to call getActions() for {}", (Object)descriptor);
        }
        return (Page)actions.getOrElse((Object)DefaultPage.only(Collections.singletonList(new RenderingErrorAction(descriptor))));
    }

    @Override
    public String invokeGetPersistentMarkup(GetActionsRequest request, IssueTabPanelModuleDescriptor descriptor) {
        return (String)SafePluginPointAccess.call(() -> ((PaginatedIssueTabPanel)descriptor.getModule()).getPersistentMarkup(request)).getOrElse((Object)"");
    }

    class RenderingErrorAction
    implements IssueAction {
        private final IssueTabPanelModuleDescriptor moduleDescriptor;

        public RenderingErrorAction(IssueTabPanelModuleDescriptor moduleDescriptor) {
            this.moduleDescriptor = moduleDescriptor;
        }

        public String getHtml() {
            return IssueTabPanelInvokerImpl.this.i18Factory.getInstance(IssueTabPanelInvokerImpl.this.jiraAuthenticationContext.getUser()).getText("modulewebcomponent.exception", this.moduleDescriptor.getCompleteKey());
        }

        public Date getTimePerformed() {
            return new java.sql.Date(System.currentTimeMillis());
        }

        public boolean isDisplayActionAllTab() {
            return true;
        }
    }
}

