/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webresource;

import com.atlassian.plugin.servlet.ResourceDownloadUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tuckey.web.filters.urlrewrite.extend.RewriteMatch;
import org.tuckey.web.filters.urlrewrite.extend.RewriteRule;

public class CachingResourceDownloadRewriteRule
extends RewriteRule {
    public static final String PATH_SEPARATOR = "/";
    private static final Pattern PATH_PATTERN = Pattern.compile("^/s/(.*)/_/(.*)");
    private static final Pattern PATHS_DENIED = Pattern.compile("[^a-zA-Z0-9]((?i)(WEB-INF)|(META-INF))[^a-zA-Z0-9]");

    public RewriteMatch matches(HttpServletRequest request, HttpServletResponse response) {
        String strippedURL = this.stripContextFrom(request);
        String decodedURL = CachingResourceDownloadRewriteRule.decodeURLSafely(strippedURL);
        String normalisedURL = this.getNormalisedPathFrom(decodedURL);
        final Matcher pathMatcher = PATH_PATTERN.matcher(normalisedURL);
        if (!pathMatcher.matches()) {
            return null;
        }
        if (this.isPathDenied(normalisedURL)) {
            return null;
        }
        final String rewrittenUriPath = PATH_SEPARATOR + pathMatcher.group(2);
        final String rewrittenUrl = request.getContextPath() + rewrittenUriPath;
        return new RewriteMatch(){

            public String getMatchingUrl() {
                return rewrittenUrl;
            }

            public boolean execute(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                ResourceDownloadUtils.addPublicCachingHeaders((HttpServletRequest)request, (HttpServletResponse)response);
                request.setAttribute("cachingHeadersApplied", (Object)true);
                request.setAttribute("_statichash", (Object)pathMatcher.group(1));
                Optional<RequestDispatcher> dispatcher = Optional.ofNullable(request.getRequestDispatcher(rewrittenUriPath));
                if (dispatcher.isPresent()) {
                    dispatcher.get().forward((ServletRequest)request, (ServletResponse)response);
                } else {
                    response.sendError(404);
                }
                return true;
            }
        };
    }

    private boolean isPathDenied(String normalisedUrl) {
        return PATHS_DENIED.matcher(normalisedUrl).find();
    }

    private String getNormalisedPathFrom(String decodedURL) {
        try {
            return new URI(decodedURL).normalize().toString();
        }
        catch (URISyntaxException e) {
            return "";
        }
    }

    private String stripContextFrom(HttpServletRequest request) {
        return request.getRequestURI().substring(request.getContextPath().length());
    }

    static String decodeURLSafely(String input) {
        String url = CachingResourceDownloadRewriteRule.decodeURL(input);
        return url.length() != 0 && url.equals(CachingResourceDownloadRewriteRule.decodeURL(url)) ? url : "";
    }

    static String decodeURL(String input) {
        try {
            return URLDecoder.decode(input, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException | IllegalArgumentException e) {
            return "";
        }
    }
}

