/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.portal;

import com.atlassian.core.ofbiz.util.OFBizPropertyUtils;
import com.atlassian.gadgets.dashboard.Color;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.entity.property.JsonEntityPropertyManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.DatabaseIterable;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.portal.PortletConfiguration;
import com.atlassian.jira.portal.PortletConfigurationImpl;
import com.atlassian.jira.portal.PortletConfigurationStore;
import com.atlassian.jira.util.Resolver;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugin.ModuleCompleteKey;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.atlassian.fugue.Iterables;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.extras.ImmutableMaps;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.ofbiz.core.entity.GenericValue;

public class OfbizPortletConfigurationStore
implements PortletConfigurationStore {
    public static final String TABLE = "PortletConfiguration";
    public static final String USER_PREFERENCES_TABLE = "GadgetUserPreference";
    private final OfBizDelegator delegator;
    private final JsonEntityPropertyManager jsonEntityPropertyManager;

    public OfbizPortletConfigurationStore(OfBizDelegator delegator, JsonEntityPropertyManager jsonEntityPropertyManager) {
        Assertions.notNull((String)"delegator", (Object)delegator);
        Assertions.notNull((String)"jsonEntityPropertyManager", (Object)jsonEntityPropertyManager);
        this.delegator = delegator;
        this.jsonEntityPropertyManager = jsonEntityPropertyManager;
    }

    @Override
    public List<PortletConfiguration> getByPortalPage(Long portalPageId) {
        Assertions.notNull((String)"portalPageId", (Object)portalPageId);
        List portletConfigsListGVs = this.delegator.findByAnd(TABLE, (Map)ImmutableMap.of((Object)"portalpage", (Object)portalPageId));
        ArrayList<PortletConfiguration> portletConfigs = new ArrayList<PortletConfiguration>(portletConfigsListGVs.size());
        for (GenericValue portletConfigGV : portletConfigsListGVs) {
            portletConfigs.add(this.createConfigurationFromGv(portletConfigGV));
        }
        return portletConfigs;
    }

    @Override
    public PortletConfiguration getByPortletId(Long portletId) {
        Assertions.notNull((String)"portletId", (Object)portletId);
        List portletConfigsListGVs = this.delegator.findByAnd(TABLE, MapBuilder.singletonMap((Object)"id", (Object)portletId));
        if (!portletConfigsListGVs.isEmpty()) {
            return this.createConfigurationFromGv((GenericValue)portletConfigsListGVs.get(0));
        }
        return null;
    }

    @Override
    public void delete(PortletConfiguration pc) {
        Assertions.notNull((String)"pc", (Object)pc);
        Assertions.notNull((String)"pc.id", (Object)pc.getId());
        GenericValue gv = this.getGenericValue(pc);
        if (gv != null) {
            this.removePropertySet(gv);
            this.delegator.removeValue(gv);
            this.removeDashboardItemProperties(pc);
        }
    }

    @Override
    public void updateGadgetPosition(Long gadgetId, int row, int column, Long dashboardId) {
        Assertions.notNull((String)"gadgetId", (Object)gadgetId);
        Assertions.notNull((String)"dashboardId", (Object)dashboardId);
        int rowsUpdated = this.delegator.bulkUpdateByPrimaryKey(TABLE, MapBuilder.newBuilder().add((Object)"position", (Object)row).add((Object)"columnNumber", (Object)column).add((Object)"portalpage", (Object)dashboardId).toMap(), CollectionBuilder.newBuilder((Object[])new Long[]{gadgetId}).asList());
        if (rowsUpdated != 1) {
            throw new DataAccessException("Gadget position for gadget with id '" + gadgetId + "' not updated correctly.");
        }
    }

    @Override
    public void updateGadgetColor(Long gadgetId, Color color) {
        Assertions.notNull((String)"gadgetId", (Object)gadgetId);
        Assertions.notNull((String)"color", (Object)color);
        int rowsUpdated = this.delegator.bulkUpdateByPrimaryKey(TABLE, MapBuilder.singletonMap((Object)"color", (Object)color.toString()), CollectionBuilder.list((Object[])new Long[]{gadgetId}));
        if (rowsUpdated != 1) {
            throw new DataAccessException("Gadget color for gadget with id '" + gadgetId + "' not updated correctly.");
        }
    }

    @Override
    public void updateUserPrefs(Long gadgetId, Map<String, String> userPrefs) {
        Assertions.notNull((String)"gadgetId", (Object)gadgetId);
        Assertions.notNull((String)"userPrefs", userPrefs);
        if (this.isLocalDashboardItemWithoutReplacementUri(gadgetId)) {
            this.updateLocalDashboardItemProperties(gadgetId, userPrefs);
        } else {
            this.updateOpenSocialGadgetUserPreferences(gadgetId, userPrefs);
        }
    }

    @Override
    public void store(PortletConfiguration pc) {
        Assertions.notNull((String)"pc", (Object)pc);
        Assertions.notNull((String)"pc.id", (Object)pc.getId());
        GenericValue gv = this.getGenericValue(pc);
        if (gv == null) {
            throw new IllegalArgumentException("Can't store a portlet configuration that has no database entry.  Must add.");
        }
        gv.set("portalpage", (Object)pc.getDashboardPageId());
        gv.set("columnNumber", (Object)pc.getColumn());
        gv.set("position", (Object)pc.getRow());
        gv.set("gadgetXml", pc.getOpenSocialSpecUri().map((Function)new Function<URI, String>(){

            @Override
            public String apply(URI input) {
                return input.toASCIIString();
            }
        }).getOrNull());
        gv.set("color", (Object)pc.getColor().toString());
        gv.set("dashboardModuleCompleteKey", pc.getCompleteModuleKey().map((Function)new Function<ModuleCompleteKey, String>(){

            @Override
            public String apply(ModuleCompleteKey input) {
                return input.getCompleteKey();
            }
        }).getOrNull());
        this.updateUserPrefs(pc.getId(), pc.getUserPrefs(), (Option<URI>)pc.getOpenSocialSpecUri(), (Option<ModuleCompleteKey>)pc.getCompleteModuleKey());
        this.delegator.store(gv);
    }

    @Override
    public PortletConfiguration addGadget(Long pageId, Long portletConfigurationId, Integer column, Integer row, URI gadgetXml, Color color, Map<String, String> userPreferences) {
        return this.addDashboardItem(pageId, portletConfigurationId, column, row, (Option<URI>)Option.some((Object)gadgetXml), color, userPreferences, (Option<ModuleCompleteKey>)Option.none());
    }

    @Override
    public PortletConfiguration addDashboardItem(Long pageId, Long portletConfigurationId, Integer column, Integer row, Option<URI> openSocialSpecUri, Color color, Map<String, String> userPreferences, Option<ModuleCompleteKey> moduleKey) {
        Assertions.notNull((String)"pageId", (Object)pageId);
        Assertions.notNull((String)"column", (Object)column);
        Assertions.notNull((String)"row", (Object)row);
        Assertions.notNull((String)"color", (Object)color);
        Assertions.notNull((String)"userPreferences", userPreferences);
        GenericValue gv = EntityUtils.createValue(TABLE, MapBuilder.newBuilder().add((Object)"portalpage", (Object)pageId).add((Object)"id", (Object)portletConfigurationId).add((Object)"columnNumber", (Object)column).add((Object)"position", (Object)row).add((Object)"gadgetXml", openSocialSpecUri.map((Function)new Function<URI, String>(){

            @Override
            public String apply(URI input) {
                return input.toASCIIString();
            }
        }).getOrNull()).add((Object)"color", (Object)color.name()).add((Object)"dashboardModuleCompleteKey", moduleKey.map((Function)new Function<ModuleCompleteKey, String>(){

            @Override
            public String apply(ModuleCompleteKey input) {
                return input.getCompleteKey();
            }
        }).getOrNull()).toMap());
        this.updateUserPrefs(gv.getLong("id"), userPreferences, openSocialSpecUri, moduleKey);
        return this.createConfigurationFromGv(gv);
    }

    @Override
    public EnclosedIterable<PortletConfiguration> getAllPortletConfigurations() {
        Resolver resolver = input -> this.createConfigurationFromGv((GenericValue)input);
        return new DatabaseIterable<PortletConfiguration>(-1, resolver){

            @Override
            protected OfBizListIterator createListIterator() {
                return OfbizPortletConfigurationStore.this.delegator.findListIteratorByCondition(OfbizPortletConfigurationStore.TABLE, null);
            }
        };
    }

    protected void removePropertySet(GenericValue gv) {
        OFBizPropertyUtils.removePropertySet(gv);
    }

    @VisibleForTesting
    Map<String, String> getUserPreferences(Long id, Option<URI> openSocialSpecUri, Option<ModuleCompleteKey> completeModuleKey) {
        if (this.isLocalDashboardItemWithoutReplacementUri(openSocialSpecUri, completeModuleKey)) {
            return this.getDashboardItemProperties(id);
        }
        return this.getOpenSocialGadgetUserPreferences(id);
    }

    private void updateUserPrefs(Long gadgetId, Map<String, String> userPrefs, Option<URI> openSocialSpecUri, Option<ModuleCompleteKey> moduleKey) {
        Assertions.notNull((String)"gadgetId", (Object)gadgetId);
        Assertions.notNull((String)"userPrefs", userPrefs);
        if (this.isLocalDashboardItemWithoutReplacementUri(openSocialSpecUri, moduleKey)) {
            this.updateLocalDashboardItemProperties(gadgetId, userPrefs);
        } else {
            this.updateOpenSocialGadgetUserPreferences(gadgetId, userPrefs);
        }
    }

    private void updateLocalDashboardItemProperties(Long gadgetId, Map<String, String> properties) {
        this.removeLocalDashboardItemPreferences(gadgetId);
        for (Map.Entry<String, String> property : properties.entrySet()) {
            this.jsonEntityPropertyManager.put(EntityPropertyType.DASHBOARD_ITEM_PROPERTY.getDbEntityName(), gadgetId, property.getKey(), this.toJsonString(property.getValue()));
        }
    }

    private String toJsonString(String property) {
        return "\"" + StringEscapeUtils.escapeJson((String)property) + "\"";
    }

    private String fromJsonString(String property) {
        return StringEscapeUtils.unescapeJson((String)property.trim().substring(1, property.length() - 1));
    }

    private void updateOpenSocialGadgetUserPreferences(Long gadgetId, Map<String, String> userPrefs) {
        this.removeOpenSocialGadgetPreferences(gadgetId);
        for (Map.Entry<String, String> userPref : userPrefs.entrySet()) {
            EntityUtils.createValue(USER_PREFERENCES_TABLE, MapBuilder.build((Object)"userprefkey", (Object)userPref.getKey(), (Object)"userprefvalue", (Object)userPref.getValue(), (Object)"portletconfiguration", (Object)gadgetId));
        }
    }

    private GenericValue getGenericValue(PortletConfiguration pc) {
        return this.delegator.findById(TABLE, pc.getId());
    }

    private PortletConfiguration createConfigurationFromGv(GenericValue portletConfigGV) {
        if (portletConfigGV == null) {
            return null;
        }
        Long id = portletConfigGV.getLong("id");
        Option openSocialSpecUri = Option.option((Object)this.getGadgetXmlURI(portletConfigGV.getString("gadgetXml"), id));
        String colorString = portletConfigGV.getString("color");
        Color gadgetColor = StringUtils.isEmpty((CharSequence)colorString) ? null : Color.valueOf((String)colorString);
        Option completeModuleKey = Option.option((Object)portletConfigGV.getString("dashboardModuleCompleteKey")).map((Function)new Function<String, ModuleCompleteKey>(){

            @Override
            public ModuleCompleteKey apply(String input) {
                return new ModuleCompleteKey(input);
            }
        });
        Map<String, String> userPrefs = this.getUserPreferences(id, (Option<URI>)openSocialSpecUri, (Option<ModuleCompleteKey>)completeModuleKey);
        return new PortletConfigurationImpl(id, portletConfigGV.getLong("portalpage"), portletConfigGV.getInteger("columnNumber"), portletConfigGV.getInteger("position"), (Option<URI>)openSocialSpecUri, gadgetColor, userPrefs, (Option<ModuleCompleteKey>)completeModuleKey);
    }

    private void removeDashboardItemProperties(PortletConfiguration portletConfiguration) {
        if (this.isLocalDashboardItemWithoutReplacementUri((Option<URI>)portletConfiguration.getOpenSocialSpecUri(), (Option<ModuleCompleteKey>)portletConfiguration.getCompleteModuleKey())) {
            this.removeLocalDashboardItemPreferences(portletConfiguration.getId());
        } else {
            this.removeOpenSocialGadgetPreferences(portletConfiguration.getId());
        }
    }

    private void removeLocalDashboardItemPreferences(Long dashboardItemId) {
        this.jsonEntityPropertyManager.deleteByEntity(EntityPropertyType.DASHBOARD_ITEM_PROPERTY.getDbEntityName(), dashboardItemId);
    }

    private int removeOpenSocialGadgetPreferences(Long dashboardItemId) {
        return this.delegator.removeByAnd(USER_PREFERENCES_TABLE, (Map)ImmutableMap.of((Object)"portletconfiguration", (Object)dashboardItemId));
    }

    private boolean isLocalDashboardItemWithoutReplacementUri(Option<URI> openSocialSpecUri, Option<ModuleCompleteKey> completeModuleKey) {
        return completeModuleKey.isDefined() && openSocialSpecUri.isEmpty();
    }

    private boolean isLocalDashboardItemWithoutReplacementUri(long id) {
        Assertions.notNull((String)"portletId", (Object)id);
        List portletConfigsListGVs = this.delegator.findByAnd(TABLE, MapBuilder.singletonMap((Object)"id", (Object)id));
        if (portletConfigsListGVs.isEmpty()) {
            throw new IllegalArgumentException("You are trying to update preferences of gadget witch does not exist");
        }
        GenericValue portletConfigGV = (GenericValue)portletConfigsListGVs.get(0);
        Option openSocialSpecUri = Option.option((Object)this.getGadgetXmlURI(portletConfigGV.getString("gadgetXml"), id));
        Option completeModuleKey = Option.option((Object)portletConfigGV.getString("dashboardModuleCompleteKey")).map((Function)new Function<String, ModuleCompleteKey>(){

            @Override
            public ModuleCompleteKey apply(String input) {
                return new ModuleCompleteKey(input);
            }
        });
        return this.isLocalDashboardItemWithoutReplacementUri((Option<URI>)openSocialSpecUri, (Option<ModuleCompleteKey>)completeModuleKey);
    }

    private ImmutableMap<String, String> getDashboardItemProperties(final Long id) {
        List propertyKeys = this.jsonEntityPropertyManager.findKeys(EntityPropertyType.DASHBOARD_ITEM_PROPERTY.getDbEntityName(), id);
        return ImmutableMaps.toMap((Iterable)Iterables.collect((Iterable)propertyKeys, (Function)new Function<String, Option<Map.Entry<String, String>>>(){

            @Override
            public Option<Map.Entry<String, String>> apply(final String propertyKey) {
                return Option.option((Object)OfbizPortletConfigurationStore.this.jsonEntityPropertyManager.get(EntityPropertyType.DASHBOARD_ITEM_PROPERTY.getDbEntityName(), id, propertyKey)).map((Function)new Function<EntityProperty, Map.Entry<String, String>>(){

                    @Override
                    public Map.Entry<String, String> apply(EntityProperty entityProperty) {
                        String value = OfbizPortletConfigurationStore.this.fromJsonString(entityProperty.getValue());
                        return Maps.immutableEntry((Object)propertyKey, (Object)Strings.nullToEmpty((String)value));
                    }
                });
            }
        }));
    }

    private Map<String, String> getOpenSocialGadgetUserPreferences(Long id) {
        HashMap<String, String> ret = new HashMap<String, String>();
        List list = this.delegator.findByAnd(USER_PREFERENCES_TABLE, MapBuilder.newBuilder().add((Object)"portletconfiguration", (Object)id).toMap());
        for (GenericValue userPrefGv : list) {
            String value = userPrefGv.getString("userprefvalue");
            if (value == null) {
                value = "";
            }
            ret.put(userPrefGv.getString("userprefkey"), value);
        }
        return ret;
    }

    private URI getGadgetXmlURI(String gadgetXmlString, Long portletId) {
        if (StringUtils.isNotEmpty((CharSequence)gadgetXmlString)) {
            try {
                return new URI(gadgetXmlString);
            }
            catch (URISyntaxException e) {
                throw new DataAccessException("Invalid gadget XML URI stored for portlet with id '" + portletId + "': '" + gadgetXmlString + "'", (Throwable)e);
            }
        }
        return null;
    }

    public static final class UserPreferenceColumns {
        public static final String KEY = "userprefkey";
        public static final String VALUE = "userprefvalue";
        public static final String PORTLETID = "portletconfiguration";
    }

    public static final class Columns {
        public static final String MODULE_KEY = "dashboardModuleCompleteKey";
        public static final String COLOR = "color";
        public static final String GADGET_XML = "gadgetXml";
        public static final String PORTALPAGE = "portalpage";
        public static final String PORTLETKEY = "portletId";
        public static final String COLUMN = "columnNumber";
        public static final String ROW = "position";
        public static final String ID = "id";
    }
}

