/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.MutablePair;

class HeuristicalProjectPermissionChecker {
    private static final long MAXIMUM_CACHE_SIZE = JiraSystemProperties.getInstance().getLong(HeuristicalProjectPermissionChecker.class.getCanonicalName() + ".cacheSize", Long.valueOf(2048L));
    private static final Duration EXACT_PERMISSION_CHECK_RESULT_TTL = Duration.ofMinutes(5L);
    private static final Duration PRREFERRED_PROJECTS_FOR_USER_TTL = Duration.ofMinutes(5L);
    private final LoadingCache<CacheKey, Optional<Project>> permissionCache = CacheBuilder.newBuilder().expireAfterWrite(EXACT_PERMISSION_CHECK_RESULT_TTL).maximumSize(4L * MAXIMUM_CACHE_SIZE).build(this.findProject());
    private final LoadingCache<Optional<ApplicationUser>, Collection<Project>> userProjects = CacheBuilder.newBuilder().expireAfterWrite(PRREFERRED_PROJECTS_FOR_USER_TTL).maximumSize(MAXIMUM_CACHE_SIZE).build(HeuristicalProjectPermissionChecker.newConcurrentHashSet());
    private final PermissionManager permissionManager;

    HeuristicalProjectPermissionChecker(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    Optional<Project> findAnyProject(ProjectPermissionKey permissionKey, @Nullable ApplicationUser user) {
        CacheKey key = new CacheKey(permissionKey, Optional.ofNullable(user));
        Optional maybeProject = (Optional)this.permissionCache.getIfPresent((Object)key);
        if (maybeProject != null && maybeProject.isPresent()) {
            if (this.hasPermission(permissionKey, (Project)maybeProject.get(), user)) {
                return maybeProject;
            }
            this.permissionCache.invalidate((Object)key);
        } else if (maybeProject != null) {
            this.permissionCache.invalidate((Object)key);
        }
        return (Optional)this.permissionCache.getUnchecked((Object)key);
    }

    private CacheLoader<CacheKey, Optional<Project>> findProject() {
        return new CacheLoader<CacheKey, Optional<Project>>(){

            public Optional<Project> load(CacheKey key) {
                Collection knownProjectsForUser = (Collection)HeuristicalProjectPermissionChecker.this.userProjects.getUnchecked((Object)key.getUser());
                Supplier<Stream> knownProjectsWithMatch = () -> HeuristicalProjectPermissionChecker.this.permissionCache.asMap().values().stream().filter(Optional::isPresent).map(Optional::get).distinct();
                Supplier<Stream> allProjects = () -> ComponentAccessor.getProjectManager().getProjectObjects().stream();
                HashSet processedProjects = new HashSet();
                Supplier[] supplierArray = new Supplier[3];
                supplierArray[0] = knownProjectsForUser::stream;
                supplierArray[1] = knownProjectsWithMatch;
                supplierArray[2] = allProjects;
                Stream<Supplier> projects = Stream.of(supplierArray);
                Optional<Project> maybeProject = projects.flatMap(Supplier::get).filter(processedProjects::add).filter(project -> HeuristicalProjectPermissionChecker.this.hasPermission(key.getProjectPermissionKey(), project, key.getUser().orElse(null))).findAny();
                maybeProject.ifPresent(knownProjectsForUser::add);
                return maybeProject;
            }
        };
    }

    private boolean hasPermission(ProjectPermissionKey permissionKey, Project p, ApplicationUser user) {
        return this.permissionManager.hasPermission(permissionKey, p, user);
    }

    private static <I> CacheLoader<I, Collection<Project>> newConcurrentHashSet() {
        return new CacheLoader<I, Collection<Project>>(){

            public Collection<Project> load(I ignored) {
                return ConcurrentHashMap.newKeySet();
            }
        };
    }

    private static final class CacheKey
    extends MutablePair<ProjectPermissionKey, Optional<ApplicationUser>> {
        private CacheKey(ProjectPermissionKey permissionKey, Optional<ApplicationUser> user) {
            super((Object)permissionKey, user);
        }

        private Optional<ApplicationUser> getUser() {
            return (Optional)this.right;
        }

        private ProjectPermissionKey getProjectPermissionKey() {
            return (ProjectPermissionKey)this.left;
        }
    }
}

