/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.jwt;

import java.util.Objects;

public class ImageAttachmentJwtToken {
    private final boolean isTokenValid;
    private final String userName;
    private final String absoluteRequestUrl;
    private final Long createdAtMillis;

    protected ImageAttachmentJwtToken(boolean isTokenValid, String userName, String absoluteRequestUrl, Long createdAtMillis) {
        this.isTokenValid = Objects.requireNonNull(isTokenValid);
        this.userName = Objects.requireNonNull(userName);
        this.absoluteRequestUrl = Objects.requireNonNull(absoluteRequestUrl);
        this.createdAtMillis = Objects.requireNonNull(createdAtMillis);
    }

    public boolean isMatchingUrl(String absoluteRequestUrl) {
        return this.absoluteRequestUrl.equals(absoluteRequestUrl);
    }

    public boolean isMatchingUserName(String userName) {
        return this.userName.equals(userName);
    }

    public boolean isTokenValid() {
        return this.isTokenValid;
    }

    public boolean isTokenExpired() {
        return !this.isTokenValid;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getAbsoluteRequestUrl() {
        return this.absoluteRequestUrl;
    }

    public long getTokenAgeSeconds(long currentTimeMillis) {
        return (currentTimeMillis - this.createdAtMillis) / 1000L;
    }
}

