/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.xsrf;

import com.atlassian.http.method.Methods;
import com.atlassian.jira.security.ActionInvocationCheckerBase;
import com.atlassian.jira.security.xsrf.DoesNotRequireXsrfCheck;
import com.atlassian.jira.security.xsrf.OriginChecker;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.security.xsrf.XsrfCheckResult;
import com.atlassian.jira.security.xsrf.XsrfDefaults;
import com.atlassian.jira.security.xsrf.XsrfInvocationChecker;
import com.atlassian.jira.security.xsrf.XsrfTokenGenerator;
import com.atlassian.jira.util.ComponentLocator;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.dbc.Null;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import webwork.action.Action;
import webwork.action.ActionContext;
import webwork.action.CommandDriven;
import webwork.config.Configuration;
import webwork.config.util.ActionInfo;

public class DefaultXsrfInvocationChecker
extends ActionInvocationCheckerBase
implements XsrfInvocationChecker {
    private final ComponentLocator componentLocator;
    private static final String NO_CHECK = "no-check";

    public DefaultXsrfInvocationChecker(ComponentLocator componentLocator) {
        this.componentLocator = componentLocator;
    }

    @Nonnull
    public XsrfCheckResult checkActionInvocation(@Nonnull Action action, @Nonnull Map<String, ?> parameters) {
        Null.not("action", action);
        Null.not("parameters", parameters);
        HttpServletRequest httpServletRequest = this.getActionHttpRequest();
        Assertions.stateNotNull((String)"httpServletRequest", (Object)httpServletRequest);
        return this.checkInvocation(action, parameters, httpServletRequest);
    }

    @Nonnull
    public XsrfCheckResult checkWebRequestInvocation(@Nonnull HttpServletRequest httpServletRequest) {
        Map parameters = httpServletRequest.getParameterMap();
        Null.not("httpServletRequest", httpServletRequest);
        Null.not("httpServletRequest.parameters", parameters);
        return this.checkInvocation(null, parameters, httpServletRequest);
    }

    private XsrfCheckResult checkInvocation(Action action, Map<String, ?> parameters, @Nonnull HttpServletRequest httpRequest) {
        if (this.needsXsrfCheck(action, httpRequest)) {
            String token = this.getXsrfToken(parameters);
            XsrfTokenGenerator tokenGenerator = this.getXsrfTokenGenerator();
            boolean passed = tokenGenerator.validateToken(httpRequest, token);
            boolean authed = tokenGenerator.generatedByAuthenticatedUser(token);
            boolean originAllowed = OriginChecker.isOriginAllowed(httpRequest);
            return DefaultXsrfInvocationChecker.createResult(true, passed, authed, originAllowed, StringUtils.isNotBlank((CharSequence)token));
        }
        return DefaultXsrfInvocationChecker.createResult(false, true, true, true, true);
    }

    private static XsrfCheckResult createResult(final boolean required, final boolean passed, final boolean authed, final boolean originAllowed, final boolean tokenPresent) {
        return new XsrfCheckResult(){

            public boolean isRequired() {
                return required;
            }

            public boolean isValid() {
                return passed;
            }

            public boolean isGeneratedForAuthenticatedUser() {
                return authed;
            }

            public boolean isOriginAllowed() {
                return originAllowed;
            }

            public boolean isTokenPresent() {
                return tokenPresent;
            }

            public String toString() {
                return String.format("required=%b valid=%b authed=%b originAllowed=%b tokenPresent=%b", required, passed, authed, originAllowed, tokenPresent);
            }
        };
    }

    private boolean needsXsrfCheck(Action action, @Nonnull HttpServletRequest httpRequest) {
        if (this.requestHasOptOutHeader(httpRequest)) {
            return false;
        }
        XsrfDefaults defaults = this.getXsrfDefaults();
        if (!defaults.isXsrfProtectionEnabled()) {
            return false;
        }
        if (action == null) {
            return true;
        }
        if (action instanceof CommandDriven) {
            if (this.hasRequiresXsrfCheckAnnotationAtCommand((CommandDriven)action)) {
                return true;
            }
            if (this.hasDoesNotRequireXsrfCheckAnnotationAtCommand((CommandDriven)action)) {
                return false;
            }
        }
        if (this.hasRequiresXsrfCheckAnnotationAtClass(action)) {
            return true;
        }
        if (this.hasDoesNotRequireXsrfCheckAnnotationAtClass(action)) {
            return false;
        }
        return Methods.isMutative((String)httpRequest.getMethod()) && defaults.isXsrfProtectionRequestMethodDependentChecksEnabled();
    }

    private boolean requestHasOptOutHeader(HttpServletRequest httpRequest) {
        String tokenValue;
        return httpRequest != null && StringUtils.isNotBlank((CharSequence)(tokenValue = httpRequest.getHeader("X-Atlassian-Token"))) && NO_CHECK.equals(tokenValue.trim().toLowerCase());
    }

    private boolean hasRequiresXsrfCheckAnnotationAtCommand(@Nonnull CommandDriven action) {
        return this.isCommandAnnotatedWith(action, RequiresXsrfCheck.class);
    }

    private boolean hasDoesNotRequireXsrfCheckAnnotationAtCommand(@Nonnull CommandDriven action) {
        return this.isCommandAnnotatedWith(action, DoesNotRequireXsrfCheck.class);
    }

    private boolean hasRequiresXsrfCheckAnnotationAtClass(@Nonnull Action action) {
        return action.getClass().isAnnotationPresent(RequiresXsrfCheck.class);
    }

    private boolean hasDoesNotRequireXsrfCheckAnnotationAtClass(@Nonnull Action action) {
        return action.getClass().isAnnotationPresent(DoesNotRequireXsrfCheck.class);
    }

    private boolean isCommandAnnotatedWith(@Nonnull CommandDriven action, Class<? extends Annotation> annotation) {
        Method method = this.getMethod(action.getClass(), this.getMethodName(action.getCommandName()));
        if (method != null) {
            return method.isAnnotationPresent(annotation);
        }
        return false;
    }

    HttpServletRequest getActionHttpRequest() {
        return ActionContext.getRequest();
    }

    ActionInfo getActionInfo(String magicKey) {
        return (ActionInfo)Configuration.get((String)magicKey);
    }

    private String getXsrfToken(Map<String, ?> parameters) {
        String[] tokenArr;
        Object mapObj = parameters.get("atl_token");
        if (mapObj instanceof String[] && (tokenArr = (String[])mapObj).length > 0) {
            return tokenArr[0];
        }
        return null;
    }

    private XsrfDefaults getXsrfDefaults() {
        return (XsrfDefaults)this.componentLocator.getComponentInstanceOfType(XsrfDefaults.class);
    }

    private XsrfTokenGenerator getXsrfTokenGenerator() {
        return (XsrfTokenGenerator)this.componentLocator.getComponentInstanceOfType(XsrfTokenGenerator.class);
    }
}

