/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.services.analytics;

import com.atlassian.jira.service.services.analytics.JiraAnalyticTask;
import com.atlassian.jira.service.services.analytics.start.GroupAnalyticTask;
import com.atlassian.jira.service.services.analytics.start.Ipv6StatusAnalyticTask;
import com.atlassian.jira.service.services.analytics.start.JiraBasicStatsAnalyticTask;
import com.atlassian.jira.service.services.analytics.start.JiraSystemAnalyticTask;
import com.atlassian.jira.service.services.analytics.start.ModifiedFilesAnalyticTask;
import com.atlassian.jira.service.services.analytics.start.UserAnalyticTask;
import com.atlassian.jira.service.services.analytics.start.WorkflowAnalyticTask;
import com.atlassian.jira.service.services.analytics.stop.ReportUptimeAnalyticsTask;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraStartStopAnalyticHelper {
    private static final Logger log = LoggerFactory.getLogger(JiraStartStopAnalyticHelper.class);

    @Nonnull
    public Map<String, Object> getOnStartUsageStats(boolean onlyDataShapeStatistics) {
        List<? extends JiraAnalyticTask> tasks = this.getStartupTasks();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (JiraAnalyticTask jiraAnalyticTask : tasks) {
            if (onlyDataShapeStatistics && !jiraAnalyticTask.isReportingDataShape()) continue;
            try {
                jiraAnalyticTask.init();
                builder.putAll(jiraAnalyticTask.getAnalytics());
            }
            catch (Exception e) {
                log.error(" Error trying to grab analytics from [{}]", (Object)jiraAnalyticTask.getClass().getName(), (Object)e);
            }
        }
        return builder.build();
    }

    public Map<String, Object> getOnStopUsageStats() {
        List<? extends JiraAnalyticTask> tasks = this.getShutdownTasks();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (JiraAnalyticTask jiraAnalyticTask : tasks) {
            try {
                jiraAnalyticTask.init();
                builder.putAll(jiraAnalyticTask.getAnalytics());
            }
            catch (Exception e) {
                log.error(" Error trying to grab analytics from [{}]", (Object)jiraAnalyticTask.getClass().getName(), (Object)e);
            }
        }
        return builder.build();
    }

    @Nonnull
    public List<? extends JiraAnalyticTask> getStartupTasks() {
        return ImmutableList.of((Object)new JiraSystemAnalyticTask(), (Object)new JiraBasicStatsAnalyticTask(), (Object)new UserAnalyticTask(), (Object)new WorkflowAnalyticTask(), (Object)new GroupAnalyticTask(), (Object)new Ipv6StatusAnalyticTask(), (Object)new ModifiedFilesAnalyticTask());
    }

    @Nonnull
    public List<? extends JiraAnalyticTask> getShutdownTasks() {
        return ImmutableList.of((Object)new ReportUptimeAnalyticsTask());
    }
}

