/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.servlet;

import com.atlassian.jira.servlet.Levenshtein;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

final class Language {
    private static final String BASE_NAME = "com.atlassian.jira.servlet.Language";
    private static Map<Locale, Language> cache = new HashMap<Locale, Language>();
    private final CharSequence alphabet;
    private final Set<String> offensiveWords;

    static Language forDefaultLocale() {
        return Language.forLocale(Locale.getDefault());
    }

    static Language forLocale(Locale locale) {
        if (!cache.containsKey(locale)) {
            ResourceBundle.Control propOnlyControl = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES);
            ResourceBundle bundle = ResourceBundle.getBundle(BASE_NAME, locale, propOnlyControl);
            String alphabet = bundle.getString("alphabet");
            String offensive = bundle.getString("offensive");
            cache.put(locale, new Language(alphabet, new HashSet<String>(Arrays.asList(offensive.split(";")))));
        }
        return cache.get(locale);
    }

    private Language(CharSequence alphabet, Set<String> offensiveWords) {
        this.alphabet = alphabet;
        this.offensiveWords = offensiveWords;
    }

    boolean isOffensive(String word) {
        assert (word != null) : "Word must not be null";
        String lowerCaseWord = word.trim().toLowerCase();
        for (String nearbyWord : Levenshtein.nearbyWords(lowerCaseWord, this.alphabet)) {
            if (!this.offensiveWords.contains(nearbyWord)) continue;
            return true;
        }
        for (String naughtyWord : this.offensiveWords) {
            if (!lowerCaseWord.contains(naughtyWord)) continue;
            return true;
        }
        return false;
    }
}

