/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharePermissionStore;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.anonymize.handlers.key.info.events.SharePermissionsFKChangedEvent;
import com.atlassian.jira.util.dbc.Assertions;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;

@EventComponent
public class CachingSharePermissionStore
implements SharePermissionStore,
Startable {
    private final SharePermissionStore delegateStore;
    private final Cache<Key, SharedEntity.SharePermissions> cache;

    public CachingSharePermissionStore(SharePermissionStore delegateStore, CacheManager cacheManager) {
        Assertions.notNull((String)"delegateStore", (Object)delegateStore);
        this.delegateStore = delegateStore;
        this.cache = cacheManager.getCache(this.getClass().getName() + ".cache", this::loadSharePermissions, new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.clearCaches();
    }

    @EventListener
    public void onSharePermissionsFKChangedEvent(SharePermissionsFKChangedEvent event) {
        this.clearCaches();
    }

    private void clearCaches() {
        this.cache.removeAll();
    }

    @Override
    public SharedEntity.SharePermissions getSharePermissions(SharedEntity entity) {
        this.validate(entity);
        Key key = CachingSharePermissionStore.createKey(entity);
        SharedEntity.SharePermissions sharePermissions = (SharedEntity.SharePermissions)this.cache.get((Object)key);
        return sharePermissions;
    }

    @Override
    public int deleteSharePermissions(SharedEntity entity) {
        this.validate(entity);
        try {
            int n = this.delegateStore.deleteSharePermissions(entity);
            return n;
        }
        finally {
            this.cache.remove((Object)CachingSharePermissionStore.createKey(entity));
        }
    }

    @Override
    public int deleteSharePermissionsLike(SharePermission permission) {
        Assertions.notNull((String)"permission", (Object)permission);
        Assertions.notNull((String)"permission.type", (Object)permission.getType());
        try {
            int n = this.delegateStore.deleteSharePermissionsLike(permission);
            return n;
        }
        finally {
            this.clearCaches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SharedEntity.SharePermissions storeSharePermissions(SharedEntity entity) {
        this.validate(entity);
        Assertions.notNull((String)"permissions", (Object)entity.getPermissions());
        try {
            SharedEntity.SharePermissions sharePermissions = this.delegateStore.storeSharePermissions(entity);
            if (sharePermissions == null) {
                sharePermissions = SharedEntity.SharePermissions.PRIVATE;
            }
            SharedEntity.SharePermissions sharePermissions2 = sharePermissions;
            return sharePermissions2;
        }
        finally {
            this.cache.remove((Object)CachingSharePermissionStore.createKey(entity));
        }
    }

    private void validate(SharedEntity entity) {
        Assertions.notNull((String)"entity", (Object)entity);
        Assertions.notNull((String)"entity.id", (Object)entity.getId());
        Assertions.notNull((String)"entity.entityType", (Object)entity.getEntityType());
    }

    public void start() throws Exception {
    }

    private static Key createKey(SharedEntity entity) {
        return new Key(entity.getId(), entity);
    }

    private SharedEntity.SharePermissions loadSharePermissions(Key key) {
        SharedEntity.Identifier identifier = new SharedEntity.Identifier(Long.valueOf(key.id), key.entityType, (ApplicationUser)null);
        SharedEntity.SharePermissions sharePermissions = this.delegateStore.getSharePermissions((SharedEntity)identifier);
        if (sharePermissions == null) {
            sharePermissions = SharedEntity.SharePermissions.PRIVATE;
        }
        return sharePermissions;
    }

    private static class Key
    implements Serializable {
        private final long id;
        private final SharedEntity.TypeDescriptor<SharedEntity> entityType;

        public Key(long id, SharedEntity entity) {
            Assertions.notNull((String)"id", (Object)id);
            Assertions.notNull((String)"entity", (Object)entity);
            this.id = id;
            this.entityType = entity.getEntityType();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.id != key.id) {
                return false;
            }
            return this.entityType.equals(key.entityType);
        }

        public int hashCode() {
            int result = (int)(this.id ^ this.id >>> 32);
            result = 31 * result + this.entityType.hashCode();
            return result;
        }

        public String toString() {
            return this.id + ":" + this.entityType;
        }
    }
}

