/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.index;

import com.atlassian.jira.issue.index.indexers.impl.FieldIndexerUtil;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.SharedEntityColumnDefinition;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;

public interface SharedEntityFieldFactory {
    public String getFieldName();

    public Collection<Field> getField(SharedEntity var1);

    @Immutable
    public static abstract class Default
    implements SharedEntityFieldFactory {
        static final Default ID = new Default(SharedEntityColumnDefinition.ID, Field.Store.YES, false){

            @Override
            String getValue(SharedEntity entity) {
                return entity.getId().toString();
            }
        };
        static final Default NAME = new Default(SharedEntityColumnDefinition.NAME, Field.Store.YES, true){

            @Override
            String getValue(SharedEntity entity) {
                return entity.getName();
            }
        };
        static final Default NAME_CASE_INSENSITIVE = new Default(SharedEntityColumnDefinition.NAME.getCaseInsensitiveColumn(), SharedEntityColumnDefinition.NAME.getSortType(), Field.Store.NO, false){

            @Override
            String getValue(SharedEntity entity) {
                String result = entity.getName();
                return result == null ? null : result.toLowerCase();
            }
        };
        static final Default NAME_SORT = new Default(SharedEntityColumnDefinition.NAME.getSortColumn(), SharedEntityColumnDefinition.NAME.getSortType(), Field.Store.YES, false){

            @Override
            String getValue(SharedEntity entity) {
                String result = entity.getName();
                return result == null ? null : FieldIndexerUtil.getValueForSorting((String)result.toLowerCase());
            }
        };
        static final Default DESCRIPTION = new Default(SharedEntityColumnDefinition.DESCRIPTION, Field.Store.YES, true){

            @Override
            String getValue(SharedEntity entity) {
                return entity.getDescription();
            }
        };
        static final Default DESCRIPTION_SORT = new Default(SharedEntityColumnDefinition.DESCRIPTION.getSortColumn(), SharedEntityColumnDefinition.DESCRIPTION.getSortType(), Field.Store.YES, true){

            @Override
            String getValue(SharedEntity entity) {
                String result = entity.getDescription();
                return result == null ? null : FieldIndexerUtil.getValueForSorting((String)result.toLowerCase());
            }
        };
        static final Default OWNER = new Default(SharedEntityColumnDefinition.OWNER, Field.Store.YES, false){

            @Override
            String getValue(SharedEntity entity) {
                return entity.getOwner() == null ? null : entity.getOwner().getKey();
            }
        };
        static final Default FAVOURITE_COUNT = new Default(SharedEntityColumnDefinition.FAVOURITE_COUNT, Field.Store.YES, false){

            @Override
            String getValue(SharedEntity entity) {
                return String.valueOf(entity.getFavouriteCount());
            }
        };
        static final List<Default> BUILDERS = Collections.unmodifiableList(Lists.newArrayList((Object[])new Default[]{ID, NAME, NAME_SORT, NAME_CASE_INSENSITIVE, DESCRIPTION, DESCRIPTION_SORT, OWNER, FAVOURITE_COUNT}));
        private final String fieldName;
        private final Field.Store store;
        private final boolean analysed;
        private final SortField.Type sortType;

        private Default(SharedEntityColumnDefinition columnDefinition, Field.Store store, boolean analysed) {
            this(columnDefinition.getName(), columnDefinition.getSortType(), store, analysed);
        }

        private Default(String fieldName, SortField.Type sortType, Field.Store store, boolean analysed) {
            this.fieldName = fieldName;
            this.sortType = sortType;
            this.analysed = analysed;
            this.store = store;
        }

        @Override
        public Collection<Field> getField(SharedEntity entity) {
            String value = this.getValue(entity);
            value = value == null ? "" : value;
            ImmutableList.Builder builder = ImmutableList.builder();
            String fieldName = this.getFieldName();
            if (this.analysed) {
                builder.add((Object)new TextField(fieldName, value, this.store));
            } else {
                builder.add((Object)new StringField(fieldName, value, this.store));
            }
            builder.add((Object)this.getDocValues(fieldName, value));
            return builder.build();
        }

        private Field getDocValues(String fieldName, String value) {
            switch (this.sortType) {
                case INT: {
                    return new NumericDocValuesField(fieldName, Long.valueOf(value).longValue());
                }
                case STRING: 
                case CUSTOM: {
                    return new SortedDocValuesField(fieldName, new BytesRef((CharSequence)value));
                }
            }
            throw new IllegalArgumentException("Unsupported sort type: " + this.sortType.name());
        }

        @Override
        public String getFieldName() {
            return this.fieldName;
        }

        abstract String getValue(SharedEntity var1);
    }
}

