/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.type;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.event.sharedentity.EntitySharedWithForeignGroup;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.search.GroupShareTypeSearchParameter;
import com.atlassian.jira.sharing.search.ShareTypeSearchParameter;
import com.atlassian.jira.sharing.type.AbstractShareTypeValidator;
import com.atlassian.jira.sharing.type.GroupShareType;
import com.atlassian.jira.sharing.type.ShareTypeValidator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import org.apache.commons.lang3.StringUtils;

public class GroupShareTypeValidator
extends AbstractShareTypeValidator
implements ShareTypeValidator {
    private static final EntitySharedWithForeignGroup entitySharedEvent = new EntitySharedWithForeignGroup();
    private final GlobalPermissionManager globalPermissionManager;
    private final GroupManager groupManager;
    private final FeatureManager featureManager;
    private final EventPublisher eventPublisher;

    public GroupShareTypeValidator(GlobalPermissionManager globalPermissionManager, GroupManager groupManager, FeatureManager featureManager, EventPublisher eventPublisher) {
        this.globalPermissionManager = globalPermissionManager;
        this.groupManager = groupManager;
        this.featureManager = featureManager;
        this.eventPublisher = eventPublisher;
    }

    public boolean checkSharePermission(JiraServiceContext ctx, SharePermission permission) {
        Assertions.notNull((String)"ctx", (Object)ctx);
        Assertions.notNull((String)"permission", (Object)permission);
        ApplicationUser user = (ApplicationUser)Assertions.notNull((String)"ctx.user", (Object)ctx.getLoggedInApplicationUser());
        Assertions.equals((String)GroupShareType.TYPE.toString(), (Object)GroupShareType.TYPE, (Object)permission.getType());
        boolean hasPermission = this.globalPermissionManager.hasPermission(GlobalPermissionKey.CREATE_SHARED_OBJECTS, user);
        if (!hasPermission) {
            ctx.getErrorCollection().addError("shares", ctx.getI18nBean().getText("common.sharing.exception.no.share.permission"));
        } else if (StringUtils.isBlank((CharSequence)permission.getParam1())) {
            String groupName = permission.getParam1() == null ? "" : permission.getParam1();
            ctx.getErrorCollection().addError("shares", ctx.getI18nBean().getText("common.sharing.exception.group.not.valid", groupName));
        } else if (!this.validateUsageContext(permission)) {
            ctx.getErrorCollection().addErrorMessage(ctx.getI18nBean().getText("common.sharing.exception.invalid.usage.context.group", permission.getParam1()));
        } else {
            Group group = this.getGroup(permission.getParam1());
            String userName = user.getDisplayName();
            if (group == null) {
                ctx.getErrorCollection().addError("shares", ctx.getI18nBean().getText("common.sharing.exception.group.no.permission", permission.getParam1()));
                ctx.getErrorCollection().addError("shares_delegated", ctx.getI18nBean().getText("common.sharing.exception.delegated.group.no.permission", permission.getParam1(), userName));
            } else if (!this.groupManager.isUserInGroup(user, group)) {
                if (this.canShareWithAllGroups(user)) {
                    this.eventPublisher.publish((Object)entitySharedEvent);
                } else if (this.onlyMembersCanShareGroup()) {
                    ctx.getErrorCollection().addError("shares", ctx.getI18nBean().getText("common.sharing.exception.group.no.permission", permission.getParam1()));
                    ctx.getErrorCollection().addError("shares_delegated", ctx.getI18nBean().getText("common.sharing.exception.delegated.group.no.permission", permission.getParam1(), userName));
                }
            }
        }
        return !ctx.getErrorCollection().hasAnyErrors();
    }

    public boolean checkSearchParameter(JiraServiceContext ctx, ShareTypeSearchParameter searchParameter) {
        Assertions.notNull((String)"ctx", (Object)ctx);
        Assertions.notNull((String)"searchParameter", (Object)searchParameter);
        Assertions.equals((String)GroupShareType.TYPE.toString(), (Object)GroupShareType.TYPE, (Object)searchParameter.getType());
        ApplicationUser user = ctx.getLoggedInApplicationUser();
        if (user == null) {
            ctx.getErrorCollection().addError("shares", ctx.getI18nBean().getText("common.sharing.searching.exception.anonymous.group.search"));
        } else {
            GroupShareTypeSearchParameter groupShareTypeSearchParameter = (GroupShareTypeSearchParameter)searchParameter;
            String groupName = groupShareTypeSearchParameter.getGroupName();
            if (StringUtils.isNotBlank((CharSequence)groupName)) {
                Group group = this.getGroup(groupName);
                if (group == null) {
                    ctx.getErrorCollection().addError("shares", ctx.getI18nBean().getText("common.sharing.exception.group.no.permission", groupName));
                    ctx.getErrorCollection().addError("shares_delegated", ctx.getI18nBean().getText("common.sharing.exception.delegated.group.no.permission", groupName, user.getDisplayName()));
                } else if (!this.groupManager.isUserInGroup(user, group)) {
                    ctx.getErrorCollection().addError("shares", ctx.getI18nBean().getText("common.sharing.exception.group.no.permission", groupName));
                    ctx.getErrorCollection().addError("shares_delegated", ctx.getI18nBean().getText("common.sharing.exception.delegated.group.no.permission", groupName, user.getDisplayName()));
                }
            }
        }
        return !ctx.getErrorCollection().hasAnyErrors();
    }

    Group getGroup(String groupName) {
        return this.groupManager.getGroup(groupName);
    }

    private boolean canShareWithAllGroups(ApplicationUser user) {
        if (!this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user)) {
            return false;
        }
        return this.featureManager.isEnabled(JiraFeatureFlagRegistrar.ADMINS_CAN_SHARE_FILTERS_AND_DASHBOARDS_WITH_ALL_GROUPS_AND_ROLES) || this.featureManager.isEnabled(JiraFeatureFlagRegistrar.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
    }

    private boolean onlyMembersCanShareGroup() {
        return !this.featureManager.isEnabled(JiraFeatureFlagRegistrar.SER_ALLOW_SHARE_WITH_NON_MEMBER);
    }
}

