/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.type;

import com.atlassian.jira.config.util.EncodingConfiguration;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.type.ShareTypeRenderer;
import com.atlassian.jira.sharing.type.UserShareType;
import com.atlassian.jira.sharing.type.VelocityShareTypeRenderer;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.opensymphony.util.TextUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.text.StringEscapeUtils;

public class UserShareTypeRenderer
extends VelocityShareTypeRenderer {
    private final UserManager userManager;

    public UserShareTypeRenderer(EncodingConfiguration encoding, VelocityTemplatingEngine templatingEngine, UserManager userManager, GlobalPermissionManager globalPermissionManager) {
        super(encoding, templatingEngine, globalPermissionManager);
        this.userManager = userManager;
    }

    public String renderPermission(SharePermission permission, JiraAuthenticationContext userCtx) {
        this.assertParams(permission, userCtx);
        return userCtx.getI18nHelper().getText("common.sharing.shared.display.user", "<b>", "</b>", this.getUserNameOrDefault(userCtx, permission), UserShareTypeRenderer.getRightsDescription(permission.getRights(), userCtx));
    }

    public String getSimpleDescription(SharePermission permission, JiraAuthenticationContext userCtx) {
        this.assertParams(permission, userCtx);
        return userCtx.getI18nHelper().getText("common.sharing.shared.display.user.desc", this.getUserNameOrDefault(userCtx, permission), UserShareTypeRenderer.getRightsDescription(permission.getRights(), userCtx));
    }

    public String getShareTypeEditor(JiraAuthenticationContext userCtx) {
        return this.renderVelocity("share-type-user-selector.vm", new HashMap<String, Object>(), userCtx);
    }

    public boolean isAddButtonNeeded(JiraAuthenticationContext userCtx) {
        return true;
    }

    public String getShareTypeLabel(JiraAuthenticationContext userCtx) {
        Assertions.notNull((String)"authenticationContext", (Object)userCtx);
        return userCtx.getI18nHelper().getText("common.words.user");
    }

    public Map<String, String> getTranslatedTemplates(JiraAuthenticationContext userCtx, SharedEntity.TypeDescriptor<? extends SharedEntity> type, ShareTypeRenderer.RenderMode mode) {
        Assertions.notNull((String)"authenticationContext", (Object)userCtx);
        Assertions.notNull((String)"type", type);
        Assertions.notNull((String)"mode", (Object)mode);
        HashMap<String, String> templates = new HashMap<String, String>();
        if (mode == ShareTypeRenderer.RenderMode.EDIT) {
            templates.put("share_user_display", StringEscapeUtils.escapeEcmaScript((String)userCtx.getI18nHelper().getText("common.sharing.shared.template.user", "<b>", "</b>")));
            templates.put("share_user_description", StringEscapeUtils.escapeEcmaScript((String)userCtx.getI18nHelper().getText("common.sharing.shared.template.user.desc")));
        } else if (mode == ShareTypeRenderer.RenderMode.SEARCH) {
            templates.put("share_user_description", StringEscapeUtils.escapeEcmaScript((String)userCtx.getI18nHelper().getText("common.sharing.search.template.user.desc." + type.getName())));
        }
        return Collections.unmodifiableMap(templates);
    }

    private void assertParams(SharePermission permission, JiraAuthenticationContext userCtx) {
        Assertions.notNull((String)"permission", (Object)permission);
        Assertions.notNull((String)"authenticationContext", (Object)userCtx);
        Assertions.equals((String)"permissionType", (Object)UserShareType.TYPE, (Object)permission.getType());
    }

    private String getUserNameOrDefault(JiraAuthenticationContext userCtx, SharePermission permission) {
        ApplicationUser user = this.userManager.getUserByKey(permission.getParam1());
        return user == null ? userCtx.getI18nHelper().getText("common.sharing.shared.display.not.existing.user") : TextUtils.htmlEncode((String)user.getDisplayName());
    }
}

