/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugin.ha.PluginMessageSender;
import com.atlassian.jira.scheduler.JiraPassivatedSchedulerLauncher;
import com.atlassian.jira.scheduler.JiraSchedulerLauncher;
import com.atlassian.jira.startup.AnalyticsLauncher;
import com.atlassian.jira.startup.ReindexMessageListenerLauncher;
import com.atlassian.jira.upgrade.DowngradeReindexLauncher;
import com.atlassian.jira.upgrade.PluginUpgradeLauncher;
import com.atlassian.jira.upgrade.UpgradeLauncher;
import com.atlassian.jira.user.util.RecoveryAdminMapper;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.google.common.annotations.VisibleForTesting;

public class ActiveServicesLauncher {
    private final PluginUpgradeLauncher pluginUpgradeLauncher;
    private final UpgradeLauncher upgradeLauncher;
    private final DowngradeReindexLauncher downgradeReindexLauncher;
    private final AnalyticsLauncher analyticsLauncher;
    private final RecoveryAdminMapper recoveryAdminMapper;
    private final ReindexMessageListenerLauncher reindexMessageListenerLauncher;

    ActiveServicesLauncher(JohnsonProvider johnsonProvider) {
        this.upgradeLauncher = new UpgradeLauncher(johnsonProvider);
        this.downgradeReindexLauncher = new DowngradeReindexLauncher();
        this.pluginUpgradeLauncher = new PluginUpgradeLauncher();
        this.analyticsLauncher = new AnalyticsLauncher();
        this.recoveryAdminMapper = new RecoveryAdminMapper();
        this.reindexMessageListenerLauncher = new ReindexMessageListenerLauncher();
    }

    @VisibleForTesting
    ActiveServicesLauncher(UpgradeLauncher upgradeLauncher, DowngradeReindexLauncher downgradeReindexLauncher, PluginUpgradeLauncher pluginUpgradeLauncher, AnalyticsLauncher analyticsLauncher, RecoveryAdminMapper recoveryAdminMapper, ReindexMessageListenerLauncher reindexMessageListenerLauncher) {
        this.upgradeLauncher = upgradeLauncher;
        this.downgradeReindexLauncher = downgradeReindexLauncher;
        this.pluginUpgradeLauncher = pluginUpgradeLauncher;
        this.analyticsLauncher = analyticsLauncher;
        this.recoveryAdminMapper = recoveryAdminMapper;
        this.reindexMessageListenerLauncher = reindexMessageListenerLauncher;
    }

    public void start() {
        ClusterManager clusterManager = (ClusterManager)ComponentAccessor.getComponent(ClusterManager.class);
        if (clusterManager.isActive()) {
            this.upgradeLauncher.start();
            this.downgradeReindexLauncher.start();
            this.pluginUpgradeLauncher.start();
            if (clusterManager.isClustered()) {
                ((PluginMessageSender)ComponentAccessor.getComponent(PluginMessageSender.class)).activate();
            }
            this.getSchedulerLauncher().start();
            this.analyticsLauncher.start();
            this.reindexMessageListenerLauncher.start();
            this.recoveryAdminMapper.map();
        }
    }

    public void stop() {
        this.analyticsLauncher.stop();
        this.getSchedulerLauncher().stop();
        PluginMessageSender messageSender = (PluginMessageSender)ComponentAccessor.getComponent(PluginMessageSender.class);
        if (messageSender != null) {
            messageSender.stop();
        }
    }

    private JiraSchedulerLauncher getSchedulerLauncher() {
        ClusterManager clusterManager = (ClusterManager)ComponentAccessor.getComponent(ClusterManager.class);
        if (clusterManager != null && clusterManager.isActive()) {
            return new JiraSchedulerLauncher();
        }
        return new JiraPassivatedSchedulerLauncher();
    }
}

