/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.component.pico.ComponentManager;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.scheduler.OracleClusteredJobParametersTypeFixer;
import com.atlassian.jira.startup.StartupCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraDatabaseConfigChecklist {
    private static final Logger log = LoggerFactory.getLogger(JiraDatabaseConfigChecklist.class);
    private final StartupCheck[] checklist;
    private volatile boolean checksDone;
    private volatile boolean success;
    private StartupCheck failedStartupCheck;

    public JiraDatabaseConfigChecklist(DatabaseConfigurationManager databaseConfigurationManager) {
        this(new StartupCheck[]{new OracleClusteredJobParametersTypeFixer(databaseConfigurationManager).asStartupCheck()});
    }

    private JiraDatabaseConfigChecklist(StartupCheck[] checklist) {
        this.checklist = checklist;
    }

    public boolean startupOK() {
        if (!this.checksDone) {
            log.debug("Checks not done, doing them now");
            this.success = this.doStartupChecks();
            this.checksDone = true;
        }
        return this.success;
    }

    private boolean doStartupChecks() {
        log.debug("Doing database config checklist");
        for (StartupCheck startupCheck : this.checklist) {
            log.debug("Doing startup check " + startupCheck.getName());
            if (startupCheck.isOk()) continue;
            this.failedStartupCheck = startupCheck;
            ComponentManager.getInstance().extendBootstrapContainerForDisplayingErrors();
            return false;
        }
        return true;
    }

    public StartupCheck getFailedStartupCheck() {
        return this.failedStartupCheck;
    }
}

