/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.entity.Update;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.upgrade.AbstractImmediateUpgradeTask;
import com.atlassian.jira.upgrade.util.UpgradeUtils;
import java.util.List;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build70101
extends AbstractImmediateUpgradeTask {
    private static final Integer BUILD_NUMBER = 70101;
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build70101.class);
    private static final String SERVICEDESK_PROJECTS_TABLE = "AO_54307E_SERVICEDESK";
    private static final String SERVICEDESK_DISABLED_COLUMN = "DISABLED";
    private static final String PROJECT_ID_COLUMN = "PROJECT_ID";
    private static final String ID_COLUMN = "id";
    private static final String PROJECT_TYPE_COLUMN = "projecttype";
    private static final String SERVICEDESK_PROJECT_TYPE = "service_desk";
    private static final String SOFTWARE_PROJECT_TYPE = "software";
    private final EntityEngine entityEngine;
    private final ProjectManager projectManager;

    @Inject
    public UpgradeTask_Build70101(EntityEngine entityEngine, ProjectManager projectManager) {
        this.entityEngine = entityEngine;
        this.projectManager = projectManager;
    }

    @Override
    public int getBuildNumber() {
        return BUILD_NUMBER;
    }

    @Override
    public String getShortDescription() {
        return "Assigning appropriate project types for the projects on the instance";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        int projectsConvertedToServiceDesk = 0;
        int projectsConvertedToSoftware = 0;
        try {
            boolean serviceDeskExists = UpgradeUtils.tableExists(SERVICEDESK_PROJECTS_TABLE);
            for (Long projectId : this.getIdsOfProjects()) {
                if (serviceDeskExists && this.isServiceDesk(projectId)) {
                    this.setServiceDeskProjectType(projectId);
                    ++projectsConvertedToServiceDesk;
                    continue;
                }
                this.setSoftwareProjectType(projectId);
                ++projectsConvertedToSoftware;
            }
        }
        finally {
            log.info("Converted {} projects to Software and {} projects to Service Desk.", (Object)projectsConvertedToSoftware, (Object)projectsConvertedToServiceDesk);
            this.projectManager.refresh();
        }
    }

    private List<Long> getIdsOfProjects() {
        return Select.id().from("Project").runWith(this.entityEngine).asList();
    }

    /*
     * Exception decompiling
     */
    private boolean isServiceDesk(Long projectId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String quoted(String table) {
        return String.format("\"%s\"", table);
    }

    private void setServiceDeskProjectType(Long projectId) {
        this.setProjectType(projectId, SERVICEDESK_PROJECT_TYPE);
    }

    private void setSoftwareProjectType(Long projectId) {
        this.setProjectType(projectId, SOFTWARE_PROJECT_TYPE);
    }

    private void setProjectType(Long projectId, String projectType) {
        Update.into("Project").set(PROJECT_TYPE_COLUMN, projectType).whereEqual(ID_COLUMN, projectId).execute(this.entityEngine);
    }

    private String addQuotesIfPostgres(String field) {
        return this.isPostgreSQL() ? this.quoted(field) : field;
    }

    @Override
    public boolean isDowngradeTaskRequired() {
        return false;
    }
}

