/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.QOSPropertyEntry;
import com.atlassian.jira.model.querydsl.QOSPropertyString;
import com.atlassian.jira.upgrade.AbstractDelayableUpgradeTask;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class UpgradeTask_Build710001
extends AbstractDelayableUpgradeTask {
    private static final Multimap<String, String> OLD_DEFAULTS = ImmutableMultimap.builder().put((Object)"jira.lf.top.bgcolour", (Object)"#205081").put((Object)"jira.lf.top.hilightcolour", (Object)"#296ca3").put((Object)"jira.lf.top.textcolour", (Object)"#ffffff").put((Object)"jira.lf.top.texthilightcolour", (Object)"#f0f0f0").put((Object)"jira.lf.top.separator.bgcolor", (Object)"#2e3d54").put((Object)"jira.lf.menu.textcolour", (Object)"#ffffff").put((Object)"jira.lf.menu.bgcolour", (Object)"#3b73af").put((Object)"jira.lf.menu.separator", (Object)"#f0f0f0").put((Object)"jira.lf.text.headingcolour", (Object)"#333333").put((Object)"jira.lf.text.headingcolour", (Object)"#292929").put((Object)"jira.lf.text.linkcolour", (Object)"#3b73af").put((Object)"jira.lf.text.activelinkcolour", (Object)"#3b73af").put((Object)"jira.lf.hero.button.text.colour", (Object)"#ffffff").put((Object)"jira.lf.hero.button.base.bg.colour", (Object)"#3b7fc4").put((Object)"jira.lf.gadget.color1", (Object)"#3b73af").put((Object)"jira.lf.gadget.color2", (Object)"#d04437").put((Object)"jira.lf.gadget.color3", (Object)"#ea632b").put((Object)"jira.lf.gadget.color4", (Object)"#14892c").put((Object)"jira.lf.gadget.color5", (Object)"#205081").put((Object)"jira.lf.gadget.color6", (Object)"#654982").put((Object)"jira.lf.gadget.color7", (Object)"#707070").put((Object)"jira.lf.favicon.hires.url", (Object)"/images/64jira.png").put((Object)"jira.lf.logo.url", (Object)"/images/icon-jira-logo.png").build();
    private final QueryDslAccessor queryDslAccessor;

    public UpgradeTask_Build710001(QueryDslAccessor queryDslAccessor) {
        this.queryDslAccessor = queryDslAccessor;
    }

    @Override
    public int getBuildNumber() {
        return 710001;
    }

    @Override
    public String getShortDescription() {
        return "Cleanup the old defaults from DB so new defaults can be applied";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        this.resetToDefault(OLD_DEFAULTS.keySet().stream().filter(this::isDefault).collect(Collectors.toList()));
        this.refreshCaches();
    }

    private void resetToDefault(Collection<String> keys) {
        List<Long> ids = this.getPropertyId(keys);
        this.queryDslAccessor.execute(conn -> conn.delete((RelationalPath<?>)QOSPropertyString.O_S_PROPERTY_STRING).where((Predicate)QOSPropertyString.O_S_PROPERTY_STRING.id.in((Collection)ids)).execute());
        this.queryDslAccessor.execute(conn -> conn.delete((RelationalPath<?>)QOSPropertyEntry.O_S_PROPERTY_ENTRY).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.id.in((Collection)ids)).execute());
    }

    private boolean isDefault(String propertyKey) {
        return this.getStringProperty(propertyKey).map(actualValue -> OLD_DEFAULTS.get((Object)propertyKey).contains(actualValue)).orElse(false);
    }

    private List<Long> getPropertyId(Collection<String> key) {
        return this.queryDslAccessor.executeQuery(conn -> ((SQLQuery)((SQLQuery)conn.newSqlQuery().select(QOSPropertyEntry.O_S_PROPERTY_ENTRY.id).from((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY)).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey.in(key))).fetch());
    }

    private Optional<String> getStringProperty(String key) {
        return Optional.ofNullable(this.queryDslAccessor.executeQuery(conn -> (String)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)conn.newSqlQuery().select((Expression)QOSPropertyString.O_S_PROPERTY_STRING.value).from((Expression)QOSPropertyString.O_S_PROPERTY_STRING)).join((EntityPath)QOSPropertyEntry.O_S_PROPERTY_ENTRY)).on((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.id.eq(QOSPropertyString.O_S_PROPERTY_STRING.id))).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey.eq((Object)key))).fetchOne()));
    }

    private void refreshCaches() {
        ComponentAccessor.getComponentSafely(ApplicationProperties.class).ifPresent(ApplicationProperties::refresh);
    }

    @Override
    public boolean isDowngradeTaskRequired() {
        return false;
    }
}

