/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.QSharePermissions;
import com.atlassian.jira.sharing.CachingSharePermissionStore;
import com.atlassian.jira.sharing.SharePermissionUtils;
import com.atlassian.jira.sharing.rights.ShareRight;
import com.atlassian.jira.sharing.rights.ShareRights;
import com.atlassian.upgrade.api.UpgradeContext;
import com.atlassian.upgrade.spi.UpgradeTask;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build712001
implements UpgradeTask {
    private QueryDslAccessor queryDslAccessor;
    private static final int DEFAULT_RIGHTS_VIEW = SharePermissionUtils.ShareRightUtils.getIntegerValueFromShareRight((ShareRight)ShareRights.VIEW);
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build712001.class);

    public UpgradeTask_Build712001(QueryDslAccessor queryDslAccessor) {
        this.queryDslAccessor = queryDslAccessor;
    }

    public int getBuildNumber() {
        return 712001;
    }

    public String getShortDescription() {
        return "Add default value to Rights of the Share Permission entries.";
    }

    public void runUpgrade(UpgradeContext upgradeContext) {
        this.addDefaultRightsValueToSharePermissions();
    }

    private void addDefaultRightsValueToSharePermissions() {
        log.debug("Add Default value for Rights column in Share Permission table. The Default Value is: " + DEFAULT_RIGHTS_VIEW);
        this.queryDslAccessor.execute(connection -> connection.update((RelationalPath<?>)QSharePermissions.SHARE_PERMISSIONS).set(QSharePermissions.SHARE_PERMISSIONS.rights, (Object)DEFAULT_RIGHTS_VIEW).where((Predicate)QSharePermissions.SHARE_PERMISSIONS.rights.isNull().or((Predicate)QSharePermissions.SHARE_PERMISSIONS.rights.eq((Object)0))).execute());
        this.invalidateCaches();
    }

    private void invalidateCaches() {
        log.debug("Invalidate cache which store Share Permissions");
        ComponentAccessor.getComponentSafely(CachingSharePermissionStore.class).ifPresent(cachingSharePermissionStore -> cachingSharePermissionStore.onClearCache(null));
    }
}

