/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.db.config.password.ciphers.base64.Base64Cipher;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.QMailServer;
import com.atlassian.mail.server.managers.jira.OFBizMailServerManager;
import com.atlassian.upgrade.api.UpgradeContext;
import com.atlassian.upgrade.spi.UpgradeTask;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.util.ConcurrentModificationException;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build812001
implements UpgradeTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeTask_Build812001.class);
    public static final int BUILD_NUMBER = 812001;
    private final QueryDslAccessor queryDslAccessor;
    private final ClusterLockService clusterLockService;
    private final String lockName = OFBizMailServerManager.class.getName();

    public UpgradeTask_Build812001(QueryDslAccessor queryDslAccessor, ClusterLockService clusterLockService) {
        this.queryDslAccessor = queryDslAccessor;
        this.clusterLockService = clusterLockService;
    }

    public int getBuildNumber() {
        return 812001;
    }

    @Nonnull
    public String getShortDescription() {
        return "Encode mail servers passwords.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runUpgrade(UpgradeContext upgradeContext) {
        Base64Cipher base64Cipher = new Base64Cipher();
        ClusterLock lock = this.clusterLockService.getLockForName(this.lockName);
        if (!lock.tryLock()) {
            LOGGER.warn(String.format("Unable to acquire %s lock. Failing the upgrade task.", this.lockName));
            throw new ConcurrentModificationException(String.format("%d upgrade task has failed. Unable to acquire %s lock", 812001, lock));
        }
        try {
            this.queryDslAccessor.execute(conn -> {
                List mailServerDTOS = ((SQLQuery)((SQLQuery)((SQLQuery)conn.newSqlQuery().select((Expression)QMailServer.MAIL_SERVER).from((Expression)QMailServer.MAIL_SERVER)).where((Predicate)QMailServer.MAIL_SERVER.password.isNotNull())).where((Predicate)QMailServer.MAIL_SERVER.cipherType.isNull())).fetch();
                mailServerDTOS.forEach(mailServerDTO -> conn.update((RelationalPath<?>)QMailServer.MAIL_SERVER).set((Path)QMailServer.MAIL_SERVER.cipherType, (Object)"Base64Cipher").set((Path)QMailServer.MAIL_SERVER.password, (Object)base64Cipher.encrypt(mailServerDTO.getPassword())).where((Predicate)QMailServer.MAIL_SERVER.id.eq((Object)mailServerDTO.getId())).execute());
            });
        }
        finally {
            lock.unlock();
        }
    }
}

