/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.index.ha.IndexSnapshotService;
import com.atlassian.jira.model.querydsl.QServiceConfig;
import com.atlassian.jira.upgrade.AbstractDelayableUpgradeTask;
import com.atlassian.jira.web.component.cron.CronEditorBean;
import com.atlassian.jira.web.component.cron.generator.CronExpressionGenerator;
import com.atlassian.jira.web.component.cron.parser.CronExpressionParser;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.util.concurrent.TimeUnit;

public class UpgradeTask_Build819000
extends AbstractDelayableUpgradeTask {
    private static final String SERVICE_NAME = "JIRA Index Snapshot Service";
    private final QueryDslAccessor queryDslAccessor;

    public UpgradeTask_Build819000(QueryDslAccessor queryDslAccessor) {
        this.queryDslAccessor = queryDslAccessor;
    }

    @Override
    public int getBuildNumber() {
        return 819000;
    }

    @Override
    public String getShortDescription() {
        return "This upgrade task enables JIRA Index Snapshot Service by default to take a snapshot daily at 2am.If the service has been already enabled, it changes its cron expression to take a snapshoteveryday, without changing the time of the day. This is needed so that new nodes can pick up this snapshot on a startup.";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        String foundCron = this.getCronForIndexSnapshotService();
        if (foundCron == null) {
            this.insertServiceIntoServiceConfig();
        } else {
            String newCron = this.changeCronToDaily(foundCron);
            this.updateServiceCron(newCron);
        }
    }

    @VisibleForTesting
    String getCronForIndexSnapshotService() {
        return this.queryDslAccessor.executeQuery(connection -> (String)((SQLQuery)((SQLQuery)connection.newSqlQuery().select((Expression)QServiceConfig.SERVICE_CONFIG.cronExpression).from((Expression)QServiceConfig.SERVICE_CONFIG)).where((Predicate)QServiceConfig.SERVICE_CONFIG.name.eq((Object)IndexSnapshotService.getServiceName()).and((Predicate)QServiceConfig.SERVICE_CONFIG.name.eq((Object)IndexSnapshotService.getServiceName())))).fetchFirst());
    }

    @VisibleForTesting
    void updateServiceCron(String cron) {
        this.queryDslAccessor.execute(connection -> connection.update((RelationalPath<?>)QServiceConfig.SERVICE_CONFIG).set((Path)QServiceConfig.SERVICE_CONFIG.cronExpression, (Object)cron).where((Predicate)QServiceConfig.SERVICE_CONFIG.clazz.eq((Object)IndexSnapshotService.class.getName()).and((Predicate)QServiceConfig.SERVICE_CONFIG.name.eq((Object)SERVICE_NAME))).execute());
    }

    @VisibleForTesting
    void insertServiceIntoServiceConfig() {
        this.queryDslAccessor.execute(connection -> connection.insert(QServiceConfig.SERVICE_CONFIG).set((Path)QServiceConfig.SERVICE_CONFIG.cronExpression, this.getCron2amEveryday()).set((Path)QServiceConfig.SERVICE_CONFIG.time, (Object)TimeUnit.DAYS.toMillis(1L)).set((Path)QServiceConfig.SERVICE_CONFIG.name, SERVICE_NAME).set((Path)QServiceConfig.SERVICE_CONFIG.clazz, IndexSnapshotService.class.getName()).executeWithId());
    }

    @Override
    public boolean isDowngradeTaskRequired() {
        return false;
    }

    private String getCron2amEveryday() {
        CronEditorBean cronEditorBean = new CronEditorBean();
        cronEditorBean.setMode("daily");
        cronEditorBean.setHoursRunOnce("2");
        cronEditorBean.setHoursRunOnceMeridian("am");
        cronEditorBean.setMinutes("0");
        return new CronExpressionGenerator().getCronExpressionFromInput(cronEditorBean);
    }

    @VisibleForTesting
    String changeCronToDaily(String cron) {
        CronExpressionParser cronExpressionParser = new CronExpressionParser(cron);
        CronEditorBean cronEditorBean = cronExpressionParser.getCronEditorBean();
        cronEditorBean.setMode("daily");
        return new CronExpressionGenerator().getCronExpressionFromInput(cronEditorBean);
    }
}

