/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationPropertiesImpl;
import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.QOSPropertyEntry;
import com.atlassian.jira.model.querydsl.QOSPropertyNumber;
import com.atlassian.upgrade.api.UpgradeContext;
import com.atlassian.upgrade.spi.UpgradeTask;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class UpgradeTask_Build901000
implements UpgradeTask {
    private static final String JIRA_MAIN_PROPERTIES_TYPE = "jira.properties";
    private static final String JMX_STATUS_PROPERTY_KEY = "jira.monitoring.jmx.enabled";
    private static final Long PROPERTY_ENABLED = 1L;
    private final QueryDslAccessor queryDslAccessor;

    public UpgradeTask_Build901000(QueryDslAccessor queryDslAccessor) {
        this.queryDslAccessor = Objects.requireNonNull(queryDslAccessor);
    }

    public int getBuildNumber() {
        return 901000;
    }

    public String getShortDescription() {
        return "Enables JMX monitoring metrics";
    }

    public void runUpgrade(UpgradeContext upgradeContext) {
        this.queryDslAccessor.execute(dbConnection -> {
            UpgradeTask_Build901000.removeAnySetJmxProperties(dbConnection);
            UpgradeTask_Build901000.setEnableJmxProperty(dbConnection);
        });
        ComponentAccessor.getComponentSafely(ApplicationPropertiesImpl.class).ifPresent(ApplicationPropertiesImpl::refresh);
    }

    private static void removeAnySetJmxProperties(DbConnection connection) {
        List propertyEntryIdList = ((SQLQuery)((SQLQuery)connection.newSqlQuery().select(QOSPropertyEntry.O_S_PROPERTY_ENTRY.id).from((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY)).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityName.eq((Object)JIRA_MAIN_PROPERTIES_TYPE).and((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey.eq((Object)JMX_STATUS_PROPERTY_KEY)))).fetch();
        if (!propertyEntryIdList.isEmpty()) {
            connection.delete((RelationalPath<?>)QOSPropertyNumber.O_S_PROPERTY_NUMBER).where((Predicate)QOSPropertyNumber.O_S_PROPERTY_NUMBER.id.in((Collection)propertyEntryIdList)).execute();
            connection.delete((RelationalPath<?>)QOSPropertyEntry.O_S_PROPERTY_ENTRY).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.id.in((Collection)propertyEntryIdList)).execute();
        }
    }

    private static void setEnableJmxProperty(DbConnection connection) {
        Long propertyEntryId = connection.insert(QOSPropertyEntry.O_S_PROPERTY_ENTRY).set((Path)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityName, JIRA_MAIN_PROPERTIES_TYPE).set((Path)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityId, (Object)1L).set((Path)QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey, JMX_STATUS_PROPERTY_KEY).set((Path)QOSPropertyEntry.O_S_PROPERTY_ENTRY.type, (Object)1).executeWithId();
        connection.insert(QOSPropertyNumber.O_S_PROPERTY_NUMBER).set((Path)QOSPropertyNumber.O_S_PROPERTY_NUMBER.value, PROPERTY_ENABLED).set((Path)QOSPropertyNumber.O_S_PROPERTY_NUMBER.id, propertyEntryId).execute();
    }
}

