/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.role;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.tasks.role.DefaultApplicationDao;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultApplicationDaoImpl
implements DefaultApplicationDao {
    private static final Logger log = LoggerFactory.getLogger(DefaultApplicationDaoImpl.class);
    private static final String DEFAULT_APPLICATION_ENTITY = "LicenseRoleDefault";
    private final OfBizDelegator db;

    public DefaultApplicationDaoImpl(OfBizDelegator db) {
        this.db = (OfBizDelegator)Assertions.notNull((String)"db", (Object)db);
    }

    @Override
    public Set<ApplicationKey> get() {
        List allDefaultApplications = this.db.findAll(DEFAULT_APPLICATION_ENTITY);
        List skippedRoleNames = allDefaultApplications.stream().map(gv -> gv.getString("licenseRoleName")).filter(this::isApplicationKeyCorrupted).collect(Collectors.toList());
        if (!skippedRoleNames.isEmpty()) {
            log.warn("The applications keys are corrupted and will be skipped. Application keys = {}.", (Object)StringUtils.join(skippedRoleNames, (String)", "));
        }
        return allDefaultApplications.stream().map(gv -> gv.getString("licenseRoleName")).filter(ApplicationKey::isValid).map(ApplicationKey::valueOf).collect(Collectors.toSet());
    }

    @Override
    public void setApplicationsAsDefault(Set<ApplicationKey> applicationKeys) {
        Set<ApplicationKey> currentDefaults = this.get();
        Sets.difference(applicationKeys, currentDefaults).stream().forEach(this::put);
    }

    private void put(ApplicationKey applicationKey) {
        log.info("The application {} will be stored to the database as a default one.", (Object)applicationKey);
        this.db.createValue(DEFAULT_APPLICATION_ENTITY, (Map)FieldMap.build((String)"licenseRoleName", (Object)applicationKey.value()));
    }

    public boolean isApplicationKeyCorrupted(String key) {
        return !ApplicationKey.isValid((String)key);
    }

    private static class Columns {
        private static final String ROLE_NAME = "licenseRoleName";

        private Columns() {
        }
    }
}

