/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.user.UserDefaultSettingsUpdatedEvent;
import com.atlassian.jira.user.UserDefaultSettings;
import com.atlassian.jira.user.UserDefaultSettingsManager;

public class ApplicationPropertiesUserDefaultSettingsManager
implements UserDefaultSettingsManager {
    private final ApplicationProperties applicationProperties;
    private final EventPublisher eventPublisher;

    public ApplicationPropertiesUserDefaultSettingsManager(ApplicationProperties applicationProperties, EventPublisher eventPublisher) {
        this.applicationProperties = applicationProperties;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void updateSettings(UserDefaultSettings settings) {
        UserDefaultSettings oldSettings = this.getOldSettings();
        if (!oldSettings.equals((Object)settings)) {
            this.applicationProperties.setString("user.notifications.mimetype", settings.getPreferences());
            this.applicationProperties.setOption("user.notify.own.changes", settings.isNotifyUserAboutOwnChangesEnabled().booleanValue());
            this.applicationProperties.setOption("user.default.share.private", settings.isSharePrivateEnabled().booleanValue());
            this.applicationProperties.setString("user.issues.per.page", settings.getIssuesPerPage() != null ? settings.getIssuesPerPage().toString() : null);
            this.applicationProperties.setOption("user.autowatch.disabled", settings.isAutowatchEnabled() == false);
            this.eventPublisher.publish((Object)new UserDefaultSettingsUpdatedEvent(oldSettings, settings));
        }
    }

    private UserDefaultSettings getOldSettings() {
        String preference = this.applicationProperties.getString("user.notifications.mimetype");
        boolean emailUser = this.applicationProperties.getOption("user.notify.own.changes");
        boolean sharePublic = this.applicationProperties.getOption("user.default.share.private");
        String numIssues = this.applicationProperties.getString("user.issues.per.page");
        boolean autoWatch = !this.applicationProperties.getOption("user.autowatch.disabled");
        return new UserDefaultSettings(preference, Boolean.valueOf(emailUser), Boolean.valueOf(sharePublic), numIssues != null ? Integer.valueOf(Integer.parseInt(numIssues)) : null, Boolean.valueOf(autoWatch));
    }
}

