/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ExternalLinkInNewWindow;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.util.BaseUrl;
import javax.annotation.Nullable;

public class ExternalLinkInNewWindowImpl
implements ExternalLinkInNewWindow {
    private final UserPreferencesManager userPreferencesManager;
    private final FeatureManager featureManager;
    private final BaseUrl baseUrl;

    public ExternalLinkInNewWindowImpl(UserPreferencesManager userPreferencesManager, FeatureManager featureManager, BaseUrl baseUrl) {
        this.userPreferencesManager = userPreferencesManager;
        this.featureManager = featureManager;
        this.baseUrl = baseUrl;
    }

    public boolean isEnabled(@Nullable ApplicationUser user) {
        return this.featureManager.isEnabled(JiraFeatureFlagRegistrar.EXTERNAL_LINKS_NEW_IN_WINDOW) && this.userPreferencesManager.getExtendedPreferences(user).getBoolean("user.external.links.new.window");
    }

    public boolean shouldOpenInNewWindow(@Nullable ApplicationUser user, @Nullable String url) {
        return url != null && this.isEnabled(user) && !url.startsWith(this.baseUrl.getCanonicalBaseUrl());
    }
}

