/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.ApplicationFactory;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.UnfilteredCrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.core.CrowdServiceImpl;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.event.user.UserCredentialUpdatedEvent;
import com.atlassian.crowd.event.user.UserRenamedEvent;
import com.atlassian.crowd.event.user.UserUpdatedEvent;
import com.atlassian.crowd.event.user.UsersDeletedEvent;
import com.atlassian.crowd.exception.FailedAuthenticationException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.exception.runtime.UserNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.password.encoder.AtlassianSHA1PasswordEncoder;
import com.atlassian.crowd.password.encoder.PasswordEncoder;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.event.user.BeforeUserAuthenticate;
import com.atlassian.jira.event.user.LogoutEvent;
import com.atlassian.jira.event.user.UserProfileUpdatedEvent;
import com.atlassian.jira.user.JiraDelegatingCrowdService;
import com.atlassian.jira.user.LoginStats;
import com.atlassian.jira.util.stats.JiraStats;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraCrowdService
extends JiraDelegatingCrowdService
implements UnfilteredCrowdService {
    private static final Logger log = LoggerFactory.getLogger(JiraCrowdService.class);
    static final String SYSTEM_PROPERTY_AUTHENTICATE_CACHE_MAX_SIZE = "com.atlassian.jira.user.crowd.service.authenticate.cache.max.size";
    static final Integer AUTHENTICATE_CACHE_MAX_SIZE = JiraSystemProperties.getInstance().getInteger("com.atlassian.jira.user.crowd.service.authenticate.cache.max.size", Integer.valueOf(10000));
    static final String SYSTEM_PROPERTY_AUTHENTICATE_CACHE_EXPIRE_MINUTES = "com.atlassian.jira.user.crowd.service.authenticate.cache.minutes";
    static final Integer AUTHENTICATE_CACHE_EXPIRE_MINUTES = JiraSystemProperties.getInstance().getInteger("com.atlassian.jira.user.crowd.service.authenticate.cache.minutes", Integer.valueOf(15));
    static final String SYSTEM_PROPERTY_LEGACY_MODE_AUTHENTICATE = "com.atlassian.jira.user.crowd.service.authenticate.legacy";
    static final int SANITIZED_MAX_LENGTH = 100;
    private final boolean legacyModeAuthenticate;
    private final Cache<String, AuthData> authenticationCache;
    private final PasswordEncoder passwordEncoder;
    private final LoginStats loginStats;
    private final EventPublisher eventPublisher;

    public JiraCrowdService(ApplicationFactory applicationFactory, ApplicationService applicationService, DirectoryInstanceLoader directoryInstanceLoader, EventPublisher eventPublisher) {
        this((CrowdService)new CrowdServiceImpl(applicationFactory, applicationService, directoryInstanceLoader), eventPublisher, Ticker.systemTicker(), JiraSystemProperties.getInstance().getBoolean(SYSTEM_PROPERTY_LEGACY_MODE_AUTHENTICATE));
    }

    JiraCrowdService(CrowdService crowdService, EventPublisher eventPublisher, Ticker ticker, boolean legacyModeAuthenticate) {
        super(crowdService);
        this.legacyModeAuthenticate = legacyModeAuthenticate;
        this.eventPublisher = eventPublisher;
        this.passwordEncoder = new AtlassianSHA1PasswordEncoder();
        this.loginStats = JiraStats.create(LoginStats.class, LoginStats::create, false);
        this.authenticationCache = CacheBuilder.newBuilder().maximumSize((long)AUTHENTICATE_CACHE_MAX_SIZE.intValue()).expireAfterWrite((long)AUTHENTICATE_CACHE_EXPIRE_MINUTES.intValue(), TimeUnit.MINUTES).ticker(ticker).build();
        eventPublisher.register((Object)this);
    }

    private void sendBeforeUserAuthenticateEvent(String username) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            this.eventPublisher.publish((Object)new BeforeUserAuthenticate(username));
        }
        finally {
            this.loginStats.beforeUserAuthenticate(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private User doAuthenticate(String username, String credential) throws FailedAuthenticationException, OperationFailedException {
        User user;
        if (log.isTraceEnabled()) {
            log.trace("Start authenticating user: {username:{}}", (Object)JiraCrowdService.sanitized(username));
        }
        this.sendBeforeUserAuthenticateEvent(username);
        Stopwatch stopwatch = Stopwatch.createStarted();
        User user2 = null;
        try {
            user2 = super.authenticate(username, credential);
            if (user2 == null) {
                throw new IllegalStateException("Authenticate returned null user.");
            }
            user = user2;
            this.loginStats.authentication(user2 != null, stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
        catch (Throwable throwable) {
            this.loginStats.authentication(user2 != null, stopwatch.elapsed(TimeUnit.MILLISECONDS));
            if (log.isTraceEnabled()) {
                log.trace("Done authenticating user: {username:{}, success:{}, timeInMillis:{}}", new Object[]{JiraCrowdService.sanitized(username), user2 != null, stopwatch.elapsed(TimeUnit.MILLISECONDS)});
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Done authenticating user: {username:{}, success:{}, timeInMillis:{}}", new Object[]{JiraCrowdService.sanitized(username), user2 != null, stopwatch.elapsed(TimeUnit.MILLISECONDS)});
        }
        return user;
    }

    @Override
    public User userAuthenticated(String username) throws UserNotFoundException, OperationFailedException, InactiveAccountException {
        this.sendBeforeUserAuthenticateEvent(username);
        return super.userAuthenticated(username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthData getFromCacheOrLoad(String username, String credential) throws ExecutionException {
        Stopwatch stopwatchCacheGetOrLoad = Stopwatch.createStarted();
        try {
            AuthData authData = (AuthData)this.authenticationCache.get((Object)username, () -> {
                if (log.isTraceEnabled()) {
                    log.trace("Do authenticate user: {} and cache if successful...", (Object)JiraCrowdService.sanitized(username));
                }
                Stopwatch stopwatchLoad = Stopwatch.createStarted();
                User user = this.doAuthenticate(username, credential);
                AuthData authData = new AuthData(user, this.encodePassword(credential));
                if (log.isTraceEnabled()) {
                    log.trace("Authentication successful for: {} took: {} milliseconds", (Object)JiraCrowdService.sanitized(username), (Object)stopwatchLoad.elapsed(TimeUnit.MILLISECONDS));
                }
                return authData;
            });
            return authData;
        }
        finally {
            this.loginStats.authenticationCacheGetOrLoad(stopwatchCacheGetOrLoad.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    private AuthData forceCacheReLoad(String username, String credential) throws ExecutionException {
        log.trace("Force reload cache for: {}", (Object)username);
        this.invalidateCache(username);
        return this.getFromCacheOrLoad(username, credential);
    }

    private void invalidateCache(String username) {
        log.trace("Invalidating authenticationCache for: {}", (Object)username);
        this.authenticationCache.invalidate((Object)username);
        this.loginStats.cacheInvalidate();
    }

    private static String sanitized(String username) {
        if (username == null) {
            return null;
        }
        String usernameSanitized = username.replaceAll("[^A-Za-z0-9]", "_");
        if (username.length() > 100) {
            return usernameSanitized.substring(0, 100) + "...";
        }
        return usernameSanitized;
    }

    @Override
    public User authenticate(String username, String credential) throws FailedAuthenticationException, OperationFailedException {
        username = IdentifierUtils.toLowerCase((String)username);
        if (log.isTraceEnabled()) {
            log.trace("Authenticate user: {}", (Object)JiraCrowdService.sanitized(username));
        }
        this.loginStats.settings(this.legacyModeAuthenticate, AUTHENTICATE_CACHE_EXPIRE_MINUTES.intValue(), AUTHENTICATE_CACHE_MAX_SIZE, this.passwordEncoder.getKey());
        this.loginStats.user(JiraCrowdService.sanitized(username));
        if (this.legacyModeAuthenticate) {
            return this.doAuthenticate(username, credential);
        }
        try {
            AuthData authData = this.getFromCacheOrLoad(username, credential);
            if (this.isValidPassword(credential, authData)) {
                if (log.isTraceEnabled()) {
                    log.trace("Cached password for user: {} matching. Skipping authentication...", (Object)JiraCrowdService.sanitized(username));
                }
                return authData.user;
            }
            if (log.isTraceEnabled()) {
                log.trace("Cached password for user: {} different. Re-authenticating...", (Object)JiraCrowdService.sanitized(username));
            }
            return this.forceCacheReLoad((String)username, (String)credential).user;
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            Throwables.throwIfInstanceOf((Throwable)t, FailedAuthenticationException.class);
            Throwables.throwIfInstanceOf((Throwable)t, OperationFailedException.class);
            Throwables.throwIfUnchecked((Throwable)t);
            throw new RuntimeException(t);
        }
    }

    @EventListener
    public void onLogout(LogoutEvent logoutEvent) {
        String username = IdentifierUtils.toLowerCase((String)logoutEvent.getUser().getUsername());
        log.trace("onLogout for user: {}", (Object)username);
        this.invalidateCache(username);
    }

    @EventListener
    public void onUserCredentialUpdatedEvent(UserCredentialUpdatedEvent userCredentialUpdatedEvent) {
        String username = IdentifierUtils.toLowerCase((String)userCredentialUpdatedEvent.getUsername());
        log.trace("onUserCredentialUpdatedEvent for user: {}", (Object)username);
        this.invalidateCache(username);
    }

    @EventListener
    public void onUserUpdatedEvent(UserUpdatedEvent userUpdatedEvent) {
        if (!userUpdatedEvent.getUser().isActive()) {
            String username = IdentifierUtils.toLowerCase((String)userUpdatedEvent.getUser().getName());
            log.trace("onUserUpdatedEvent for inactive user: {}", (Object)username);
            this.invalidateCache(username);
        } else if (userUpdatedEvent instanceof UserRenamedEvent) {
            String oldUserName = IdentifierUtils.toLowerCase((String)((UserRenamedEvent)userUpdatedEvent).getOldUsername());
            log.trace("onUserUpdatedEvent for renamed user: {}", (Object)oldUserName);
            this.invalidateCache(oldUserName);
        }
    }

    @EventListener
    public void onUserProfileUpdateEvent(UserProfileUpdatedEvent userProfileUpdatedEvent) {
        String username = IdentifierUtils.toLowerCase((String)userProfileUpdatedEvent.getUsername());
        log.trace("onUserProfileUpdateEvent for user: {}", (Object)username);
        this.invalidateCache(username);
    }

    @EventListener
    public void onUsersDeletedEvent(UsersDeletedEvent usersDeletedEvent) {
        Collection deletedUsernames = usersDeletedEvent.getUsernames();
        for (String deletedUsername : deletedUsernames) {
            String username = IdentifierUtils.toLowerCase((String)deletedUsername);
            log.trace("onUserDeletedEvent for user: {}", (Object)username);
            this.invalidateCache(username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String encodePassword(String rawPassword) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            String string = this.passwordEncoder.encodePassword(rawPassword, null);
            return string;
        }
        finally {
            this.loginStats.encodePassword(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValidPassword(String rawPassword, AuthData authData) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            boolean bl = this.passwordEncoder.isPasswordValid(authData.encodedPassword, rawPassword, null);
            return bl;
        }
        finally {
            this.loginStats.validatePassword(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    @VisibleForTesting
    boolean isLegacyModeAuthenticate() {
        return this.legacyModeAuthenticate;
    }

    private static final class AuthData {
        final User user;
        final String encodedPassword;
        final int hashcode;

        private AuthData(User user, String encodedPassword) {
            Preconditions.checkNotNull((Object)user);
            Preconditions.checkNotNull((Object)encodedPassword);
            this.user = user;
            this.encodedPassword = encodedPassword;
            this.hashcode = Objects.hash(user, encodedPassword);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AuthData authData = (AuthData)o;
            return this.user.equals((Object)authData.user) && this.encodedPassword.equals(authData.encodedPassword);
        }

        public int hashCode() {
            return this.hashcode;
        }
    }
}

