/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.cache.CacheManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventListenerRegistrar;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.feature.OneWayDatabaseVersionFeature;
import com.atlassian.jira.config.properties.ZDUDbBackedCachedPropertySetManager;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.event.JiraUpgradedEvent;
import com.atlassian.jira.propertyset.ComponentCachingOfBizPropertyEntryStore;
import com.atlassian.jira.propertyset.JiraPropertySetFactory;
import com.atlassian.jira.user.DefaultUserPropertyManager;
import com.atlassian.jira.user.util.UserKeyStore;
import com.atlassian.jira.util.Supplier;
import com.opensymphony.module.propertyset.PropertySet;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZDUUserPropertyManager
extends DefaultUserPropertyManager {
    private static final Logger log = LoggerFactory.getLogger(ZDUUserPropertyManager.class);
    private static final String SYSTEM_PROPERTY_SINGLE_CACHE_DISABLED = "com.atlassian.jira.property.set.single.cache.user.disabled";
    private static final int JIRA_VERSION_WITH_FEATURE_ENABLED = 815000;
    private final OneWayDatabaseVersionFeature oneWayDatabaseVersionFeature = new OneWayDatabaseVersionFeature(ZDUUserPropertyManager.class.getName(), "com.atlassian.jira.property.set.single.cache.user.disabled", 815000, (Supplier<Integer>)((Supplier)zduDbBackedCachedPropertySetManager::getDatabaseBuildNumber), this::clearCaches);

    public ZDUUserPropertyManager(UserKeyStore userKeyStore, QueryDslAccessor queryDslAccessor, CacheManager cacheManager, EventListenerRegistrar eventListenerRegistrar, ZDUDbBackedCachedPropertySetManager zduDbBackedCachedPropertySetManager) {
        super(userKeyStore, queryDslAccessor, cacheManager, eventListenerRegistrar);
    }

    @Override
    @Nonnull
    protected PropertySet getPropertySetForUserId(long userId) {
        if (this.oneWayDatabaseVersionFeature.isFeatureEnabled()) {
            return super.getPropertySetForUserId(userId);
        }
        return ((JiraPropertySetFactory)ComponentAccessor.getComponent(JiraPropertySetFactory.class)).buildCachingPropertySet("ApplicationUser", Long.valueOf(userId));
    }

    @EventListener
    public void onJiraUpgradedEvent(JiraUpgradedEvent jiraUpgradedEvent) {
        this.clearCaches();
    }

    private void clearCaches() {
        log.info("Clearing caches: {}", (Object)ZDUUserPropertyManager.class.getSimpleName());
        super.onClearCache(null);
        ComponentAccessor.getComponentSafely(ComponentCachingOfBizPropertyEntryStore.class).ifPresent(cachingOfBizPropertyEntryStore -> cachingOfBizPropertyEntryStore.onClearCache(null));
    }
}

