/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.externalid;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.event.user.UserEditedEvent;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.crowd.embedded.ofbiz.ExtendedUserDao;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizUser;
import com.atlassian.jira.crowd.embedded.ofbiz.UserNotFoundException;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserExternalIdChangeService {
    private static final Logger log = LoggerFactory.getLogger(UserExternalIdChangeService.class);
    private final UserManager userManager;
    private final ExtendedUserDao extendedUserDao;
    private final GlobalPermissionManager globalPermissionManager;
    private final I18nHelper.BeanFactory i18nBeanFactory;
    private final EventPublisher eventPublisher;

    public UserExternalIdChangeService(UserManager userManager, ExtendedUserDao extendedUserDao, GlobalPermissionManager globalPermissionManager, I18nHelper.BeanFactory i18nBeanFactory, EventPublisher eventPublisher) {
        this.userManager = userManager;
        this.extendedUserDao = extendedUserDao;
        this.globalPermissionManager = globalPermissionManager;
        this.i18nBeanFactory = i18nBeanFactory;
        this.eventPublisher = eventPublisher;
    }

    public ServiceResult validate(ApplicationUser loggedInUser, String userKey) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        I18nHelper i18nBean = this.i18nBeanFactory.getInstance(loggedInUser);
        if (!this.isAdministrator(loggedInUser)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.externalId.change.no.permission"));
            return new ServiceResultImpl((ErrorCollection)errors);
        }
        ApplicationUser userToUpdate = this.userManager.getUserByKey(userKey);
        if (userToUpdate == null) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.externalId.user.not.found", userKey));
            return new ServiceResultImpl((ErrorCollection)errors);
        }
        if (!this.isSysAdmin(loggedInUser) && this.isSysAdmin(userToUpdate)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.externalId.must.be.sysadmin.to.edit.sysadmin"));
            return new ServiceResultImpl((ErrorCollection)errors);
        }
        UserManager.UserState crowdUserState = this.userManager.getUserState(userToUpdate);
        if (crowdUserState.isInMultipleDirectories()) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.externalId.multiple.directories"));
            return new ServiceResultImpl((ErrorCollection)errors);
        }
        if (this.userFromExternalDirectoryNotDeletedExternally(userToUpdate)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.externalId.external.directory"));
            return new ServiceResultImpl((ErrorCollection)errors);
        }
        return new ServiceResultImpl((ErrorCollection)errors);
    }

    public ServiceResult changeExternalId(ApplicationUser actingUser, String userKey) {
        OfBizUser user;
        ServiceResult validateOutcome = this.validate(actingUser, userKey);
        if (!validateOutcome.isValid()) {
            return validateOutcome;
        }
        I18nHelper i18nBean = this.i18nBeanFactory.getInstance(actingUser);
        ApplicationUser userToUpdate = this.userManager.getUserByKey(userKey);
        if (userToUpdate == null) {
            return ServiceOutcomeImpl.error(i18nBean.getText("admin.errors.user.externalId.user.not.found", userKey));
        }
        try {
            user = this.extendedUserDao.findOfBizUser(userToUpdate.getDirectoryId(), userToUpdate.getUsername());
        }
        catch (UserNotFoundException e) {
            log.error("User not found", (Throwable)((Object)e));
            return ServiceOutcomeImpl.error(i18nBean.getText("admin.errors.user.externalId.user.not.found", userKey));
        }
        UserTemplate userTemplate = new UserTemplate((User)user);
        userTemplate.setExternalId(UserExternalIdChangeService.generateUniqueIdentifier());
        try {
            this.extendedUserDao.update((User)userTemplate, false);
            Directory directory = this.userManager.getDirectory(Long.valueOf(userToUpdate.getDirectoryId()));
            if (directory != null) {
                this.eventPublisher.publish((Object)new UserEditedEvent((Object)this, directory, (User)userTemplate, (User)user));
            }
            return new ServiceResultImpl();
        }
        catch (com.atlassian.crowd.exception.UserNotFoundException e) {
            log.error("Error during updating external id ({})", (Object)userKey, (Object)e);
            return ServiceOutcomeImpl.error(i18nBean.getText("change.handler.processing.exception", e.getMessage()));
        }
    }

    public boolean userFromExternalDirectoryNotDeletedExternally(ApplicationUser applicationUser) {
        if (applicationUser == null) {
            return false;
        }
        Directory directory = this.userManager.getDirectory(Long.valueOf(applicationUser.getDirectoryId()));
        boolean fromExternalDirectory = !Optional.ofNullable(directory).map(Directory::getType).orElse(DirectoryType.UNKNOWN).equals((Object)DirectoryType.INTERNAL);
        boolean deletedExternally = this.extendedUserDao.isDeletedExternally(applicationUser.getDirectoryId(), applicationUser.getUsername());
        return fromExternalDirectory && !deletedExternally;
    }

    private static String generateUniqueIdentifier() {
        return UUID.randomUUID().toString();
    }

    protected boolean isAdministrator(@Nullable ApplicationUser user) {
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user);
    }

    protected boolean isSysAdmin(@Nullable ApplicationUser user) {
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, user);
    }
}

