/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.handlers.anonymize;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.database.DatabaseAccessor;
import com.atlassian.jira.database.DatabaseVendor;
import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.QChangeItem;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.UserAnonymizationHandler;
import com.atlassian.jira.user.anonymize.UserAnonymizationParameter;
import com.atlassian.jira.user.anonymize.handlers.key.info.CustomFieldHistoryInfo;
import com.atlassian.jira.user.anonymize.handlers.key.info.IssueHistoryInfo;
import com.atlassian.jira.user.util.UserKeyStore;
import com.atlassian.jira.user.util.UserManager;
import com.google.common.collect.ImmutableList;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class DisplayNameInSingleUserFieldHistory
implements UserAnonymizationHandler {
    private final QueryDslAccessor queryDslAccessor;
    private final DatabaseAccessor databaseAccessor;
    private final UserManager userManager;
    private final UserKeyStore userKeyStore;
    private final List<IssueHistoryInfo> infos;

    public DisplayNameInSingleUserFieldHistory(QueryDslAccessor queryDslAccessor, DatabaseAccessor databaseAccessor, UserManager userManager, UserKeyStore userKeyStore) {
        this.queryDslAccessor = queryDslAccessor;
        this.databaseAccessor = databaseAccessor;
        this.userManager = userManager;
        this.userKeyStore = userKeyStore;
        this.infos = ImmutableList.of((Object)new IssueHistoryInfo("assignee", QChangeItem.CHANGE_ITEM.oldvalue, QChangeItem.CHANGE_ITEM.oldstring), (Object)new IssueHistoryInfo("assignee", QChangeItem.CHANGE_ITEM.newvalue, QChangeItem.CHANGE_ITEM.newstring), (Object)new IssueHistoryInfo("reporter", QChangeItem.CHANGE_ITEM.oldvalue, QChangeItem.CHANGE_ITEM.oldstring), (Object)new IssueHistoryInfo("reporter", QChangeItem.CHANGE_ITEM.newvalue, QChangeItem.CHANGE_ITEM.newstring), (Object)new CustomFieldHistoryInfo(QChangeItem.CHANGE_ITEM.oldvalue, QChangeItem.CHANGE_ITEM.oldstring), (Object)new CustomFieldHistoryInfo(QChangeItem.CHANGE_ITEM.newvalue, QChangeItem.CHANGE_ITEM.newstring));
    }

    @VisibleForTesting
    DisplayNameInSingleUserFieldHistory(QueryDslAccessor queryDslAccessor, DatabaseAccessor databaseAccessor, UserManager userManager, UserKeyStore userKeyStore, List<IssueHistoryInfo> infos) {
        this.queryDslAccessor = queryDslAccessor;
        this.databaseAccessor = databaseAccessor;
        this.userManager = userManager;
        this.userKeyStore = userKeyStore;
        this.infos = infos;
    }

    public Collection<AffectedEntity> getAffectedEntities(UserAnonymizationParameter parameter) {
        throw new UnsupportedOperationException();
    }

    public ServiceResult update(UserAnonymizationParameter parameter) {
        String newDisplayName = Optional.ofNullable(this.userManager.getUserByKey(parameter.getUserKey())).map(user -> this.userKeyStore.getKeyFromId(user.getId())).orElse(parameter.getUserKey());
        for (IssueHistoryInfo info : this.infos) {
            this.updateCustomField(info, parameter.getUserKey(), newDisplayName);
        }
        return new ServiceResultImpl();
    }

    private void updateCustomField(IssueHistoryInfo info, String oldUserKey, String newDisplayName) {
        this.queryDslAccessor.execute(connection -> connection.update((RelationalPath<?>)info.getTable()).set((Path)info.getColumnHumanReadable(), (Object)newDisplayName).where((Predicate)QChangeItem.CHANGE_ITEM.id.in(this.getInQuery(oldUserKey, info, connection))).execute());
    }

    private SQLQuery<Long> getInQuery(String userKey, IssueHistoryInfo info, DbConnection connection) {
        SQLQuery<Long> baseQuery = this.getBaseQuery(userKey, info, connection);
        if (this.databaseAccessor.getDatabaseVendor() == DatabaseVendor.MY_SQL) {
            return (SQLQuery)SQLExpressions.select((Expression)Expressions.numberPath(Long.class, (String)"id")).from((Expression)baseQuery.as("innerQuery"));
        }
        return baseQuery;
    }

    private SQLQuery<Long> getBaseQuery(String userKey, IssueHistoryInfo foreignKeyInfo, DbConnection connection) {
        return (SQLQuery)((SQLQuery)connection.newSqlQuery().select(foreignKeyInfo.getSelect()).from((Expression)foreignKeyInfo.getTable())).where(foreignKeyInfo.getWhere(userKey, this.databaseAccessor.getDatabaseVendor()));
    }

    public int getNumberOfTasks(UserAnonymizationParameter userPropertyChangeParameter) {
        throw new UnsupportedOperationException();
    }
}

