/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.handlers.key;

import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.QCustomField;
import com.atlassian.jira.model.querydsl.QCustomFieldValue;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.ContextUtil;
import com.atlassian.jira.user.anonymize.UserKeyChangeHandler;
import com.atlassian.jira.user.anonymize.UserPropertyChangeParameter;
import com.atlassian.jira.util.I18nHelper;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomFieldValueUserKeyChangeHandler
implements UserKeyChangeHandler {
    private static final Logger log = LoggerFactory.getLogger(CustomFieldValueUserKeyChangeHandler.class);
    public static final String USERPICKER_CF_TYPE = "com.atlassian.jira.plugin.system.customfieldtypes:userpicker";
    public static final String MULTIUSERPICKER_CF_TYPE = "com.atlassian.jira.plugin.system.customfieldtypes:multiuserpicker";
    private final String fieldType;
    private final QueryDslAccessor queryDslAccessor;
    private final int nubmerOfTasks;
    private final String descriptionKey;

    public static CustomFieldValueUserKeyChangeHandler singleUserPicker(QueryDslAccessor queryDslAccessor, int numberOfTasks) {
        return new CustomFieldValueUserKeyChangeHandler(USERPICKER_CF_TYPE, queryDslAccessor, numberOfTasks, "anonymization.fk.cf.userpicker.value");
    }

    public static CustomFieldValueUserKeyChangeHandler multiUserPicker(QueryDslAccessor queryDslAccessor, int numberOfTasks) {
        return new CustomFieldValueUserKeyChangeHandler(MULTIUSERPICKER_CF_TYPE, queryDslAccessor, numberOfTasks, "anonymization.fk.cf.multiuserpicker.value");
    }

    private CustomFieldValueUserKeyChangeHandler(String fieldType, QueryDslAccessor queryDslAccessor, int nubmerOfTasks, String descriptionKey) {
        this.fieldType = fieldType;
        this.queryDslAccessor = queryDslAccessor;
        this.nubmerOfTasks = nubmerOfTasks;
        this.descriptionKey = descriptionKey;
    }

    @Nonnull
    public Collection<AffectedEntity> getAffectedEntities(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ServiceResult update(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        String originalUserKey = userPropertyChangeParameter.getOriginal();
        String targetUserKey = userPropertyChangeParameter.getTarget();
        List<Long> affectedEntities = this.getIdsOfAffectedEntities(originalUserKey);
        Context context = userPropertyChangeParameter.getContext();
        I18nHelper i18nHelper = ComponentAccessor.getJiraAuthenticationContext().getI18nHelper();
        context.setName(i18nHelper.getText(this.descriptionKey));
        try {
            long changed = affectedEntities.stream().mapToLong(customFieldValueId -> this.queryDslAccessor.executeQuery(connection -> connection.update((RelationalPath<?>)QCustomFieldValue.CUSTOM_FIELD_VALUE).set((Path)QCustomFieldValue.CUSTOM_FIELD_VALUE.stringvalue, (Object)targetUserKey).where((Predicate)QCustomFieldValue.CUSTOM_FIELD_VALUE.id.eq(customFieldValueId)).execute())).sum();
            log.info("Updated {} {} entities for {}", new Object[]{changed, "CUSTOM_FIELD_VALUE", originalUserKey});
        }
        finally {
            ContextUtil.updateProgress(context, this.nubmerOfTasks);
        }
        return new ServiceResultImpl();
    }

    private List<Long> getIdsOfAffectedEntities(String original) {
        return this.getIdentifiers(QCustomFieldValue.CUSTOM_FIELD_VALUE.id, original);
    }

    private List<Long> getIdentifiers(NumberPath<Long> identifierPath, String searchedValue) {
        return this.queryDslAccessor.executeQuery(connection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.newSqlQuery().select((Expression)identifierPath).from((Expression)QCustomFieldValue.CUSTOM_FIELD_VALUE)).from((Expression)QCustomField.CUSTOM_FIELD)).where((Predicate)QCustomField.CUSTOM_FIELD.id.eq(QCustomFieldValue.CUSTOM_FIELD_VALUE.customfield).and((Predicate)QCustomFieldValue.CUSTOM_FIELD_VALUE.stringvalue.eq((Object)searchedValue)).and((Predicate)QCustomField.CUSTOM_FIELD.customfieldtypekey.eq((Object)this.fieldType)))).distinct()).fetch());
    }

    public int getNumberOfTasks(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        return this.nubmerOfTasks;
    }
}

