/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.handlers.ownership;

import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.project.component.MutableProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentStore;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AffectedEntityType;
import com.atlassian.jira.user.anonymize.OwnershipTransferHandler;
import com.atlassian.jira.user.anonymize.OwnershipTransferParameter;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentLeadOwnershipTransferHandler
implements OwnershipTransferHandler {
    private static final Logger log = LoggerFactory.getLogger(ComponentLeadOwnershipTransferHandler.class);
    private final ProjectComponentStore projectComponentStore;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public ComponentLeadOwnershipTransferHandler(ProjectComponentStore projectComponentStore, JiraAuthenticationContext jiraAuthenticationContext) {
        this.projectComponentStore = projectComponentStore;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Nonnull
    public Collection<AffectedEntity> getAffectedEntities(@Nonnull OwnershipTransferParameter ownershipTransferParameter) {
        List<MutableProjectComponent> componentsLeadByUser = this.getComponentIdsLeadByUser(ownershipTransferParameter.getCurrentUserKey());
        if (componentsLeadByUser.isEmpty()) {
            return Collections.emptyList();
        }
        return ImmutableList.of((Object)AffectedEntity.newBuilder((AffectedEntityType)AffectedEntityType.TRANSFER_OWNERSHIP).descriptionKey("admin.projects.component.lead").numberOfOccurrences(Long.valueOf(componentsLeadByUser.size())).build());
    }

    @Nonnull
    public ServiceResult update(@Nonnull OwnershipTransferParameter ownershipTransferParameter) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        log.debug("Processing component lead change for {}", (Object)ownershipTransferParameter);
        List<MutableProjectComponent> componentsLeadByUser = this.getComponentIdsLeadByUser(ownershipTransferParameter.getCurrentUserKey());
        log.debug("Found {} components to update", (Object)componentsLeadByUser.size());
        for (MutableProjectComponent mutableComponent : componentsLeadByUser) {
            mutableComponent.setLead(ownershipTransferParameter.getTransferToUserKey());
            try {
                this.projectComponentStore.store(mutableComponent);
            }
            catch (Exception e) {
                log.error(String.format("Exception during component lead change for component %d", mutableComponent.getId()), (Throwable)e);
                errors.addErrorMessage(this.jiraAuthenticationContext.getI18nHelper().getText("change.handler.processing.exception", e.getMessage()));
            }
        }
        log.debug("Finished processing component lead change for {}", (Object)ownershipTransferParameter);
        return ServiceOutcomeImpl.from((ErrorCollection)errors);
    }

    public int getNumberOfTasks(@Nonnull OwnershipTransferParameter ownershipTransferParameter) {
        return this.getComponentIdsLeadByUser(ownershipTransferParameter.getCurrentUserKey()).size();
    }

    private List<MutableProjectComponent> getComponentIdsLeadByUser(@Nonnull String userKey) {
        return (List)this.projectComponentStore.findComponentsBylead(userKey);
    }
}

