/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.handlers.ownership;

import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.issue.subscription.FilterSubscription;
import com.atlassian.jira.issue.subscription.SubscriptionManager;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AffectedEntityType;
import com.atlassian.jira.user.anonymize.OwnershipTransferHandler;
import com.atlassian.jira.user.anonymize.OwnershipTransferParameter;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterSubscriptionOwnershipTransferHandler
implements OwnershipTransferHandler {
    private static final Logger log = LoggerFactory.getLogger(FilterSubscriptionOwnershipTransferHandler.class);
    private final SubscriptionManager subscriptionManager;
    private final UserManager userManager;
    private final I18nHelper i18nHelper;

    public FilterSubscriptionOwnershipTransferHandler(SubscriptionManager subscriptionManager, UserManager userManager, I18nHelper i18nHelper) {
        this.subscriptionManager = subscriptionManager;
        this.userManager = userManager;
        this.i18nHelper = i18nHelper;
    }

    @Nonnull
    public Collection<AffectedEntity> getAffectedEntities(@Nonnull OwnershipTransferParameter ownershipTransferParameter) {
        ApplicationUser anonymizedUser = this.userManager.getUserByKeyEvenWhenUnknown(ownershipTransferParameter.getCurrentUserKey());
        List<FilterSubscription> subscriptions = this.getSubscriptionsForGroupsOwnedByUser(anonymizedUser);
        if (!subscriptions.isEmpty()) {
            return ImmutableList.of((Object)AffectedEntity.newBuilder((AffectedEntityType)AffectedEntityType.TRANSFER_OWNERSHIP).numberOfOccurrences(Long.valueOf(subscriptions.size())).descriptionKey("ownership.transfer.handler.filter.subscription.description").build());
        }
        return ImmutableList.of();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ServiceResult update(@Nonnull OwnershipTransferParameter parameter) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ApplicationUser anonymizedUser = this.userManager.getUserByKeyEvenWhenUnknown(parameter.getCurrentUserKey());
        ApplicationUser userToTransferTo = this.userManager.getUserByKeyEvenWhenUnknown(parameter.getTransferToUserKey());
        List<FilterSubscription> subscriptions = this.getSubscriptionsForGroupsOwnedByUser(anonymizedUser);
        Context.Task task = parameter.getContext().start(null);
        try {
            this.anonymizeFilterSubscriptions(errorCollection, userToTransferTo, subscriptions);
        }
        finally {
            task.complete();
        }
        return new ServiceResultImpl((ErrorCollection)errorCollection);
    }

    public int getNumberOfTasks(@Nonnull OwnershipTransferParameter userPropertyChangeParameter) {
        return 1;
    }

    @Nonnull
    private List<FilterSubscription> getSubscriptionsForGroupsOwnedByUser(@Nullable ApplicationUser anonymizedUser) {
        return this.subscriptionManager.getSubscriptionsForUser(anonymizedUser).stream().filter(subscription -> StringUtils.isNotEmpty((CharSequence)subscription.getGroupName())).collect(Collectors.toList());
    }

    private void anonymizeFilterSubscriptions(@Nonnull SimpleErrorCollection errorCollection, @Nullable ApplicationUser userToTransferTo, @Nonnull List<FilterSubscription> subscriptions) {
        for (FilterSubscription subscription : subscriptions) {
            try {
                this.transferSubscriptionOwnership(subscription, userToTransferTo);
            }
            catch (Exception ex) {
                errorCollection.addErrorMessage(this.i18nHelper.getText("change.handler.processing.exception", ex.getMessage()));
                log.error("Error while transferring filter subscription ownership", (Throwable)ex);
            }
        }
    }

    private void transferSubscriptionOwnership(@Nonnull FilterSubscription subscription, @Nullable ApplicationUser userToTransferTo) {
        String cronExpression = this.subscriptionManager.getCronExpressionForSubscription(subscription);
        this.subscriptionManager.updateSubscription(userToTransferTo, subscription.getId(), subscription.getGroupName(), cronExpression, Boolean.valueOf(subscription.isEmailOnEmpty()));
    }
}

