/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.handlers.username.mention.project;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.ProjectDTO;
import com.atlassian.jira.model.querydsl.QProject;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.anonymize.handlers.username.mention.AnonymizeMentionsCommand;
import com.atlassian.jira.user.anonymize.handlers.username.mention.MentionAnonymizationContext;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class ChangeMentionsInProjectDescription
implements AnonymizeMentionsCommand.Worker<ProjectDTO> {
    private static final Logger log = LoggerFactory.getLogger(ChangeMentionsInProjectDescription.class);
    private final ApplicationProperties applicationProperties;
    private final ProjectManager projectManager;

    public ChangeMentionsInProjectDescription(ApplicationProperties applicationProperties, ProjectManager projectManager) {
        this.applicationProperties = applicationProperties;
        this.projectManager = projectManager;
    }

    @Override
    public void executeUpdateEntityQuery(ProjectDTO entity, QueryDslAccessor queryDslAccessor, MentionAnonymizationContext ctx) {
        if (!this.isWikiRenderingEnabled()) {
            log.debug("Wiki rendering disabled for project description. Skipping username change handler.");
            return;
        }
        queryDslAccessor.executeQuery(con -> con.update((RelationalPath<?>)QProject.PROJECT).set((Path)QProject.PROJECT.description, (Object)ctx.anonymizeMentions(entity.getDescription())).where((Predicate)QProject.PROJECT.id.eq((Object)entity.getId())).execute());
    }

    @Override
    public String getSavingErrorMessageKey() {
        return "anonymization.username.project.description.mention.saving.error";
    }

    private boolean isWikiRenderingEnabled() {
        return !this.applicationProperties.getOption("jira.project.description.html.enabled");
    }

    @Override
    public void afterUpdates() {
        this.projectManager.refresh();
    }
}

