/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.handlers.username.mention.project;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.database.DatabaseAccessor;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.database.QueryDslUtils;
import com.atlassian.jira.model.querydsl.QProject;
import com.atlassian.jira.user.anonymize.handlers.username.mention.MentionsGetAffectedEntitiesCommand;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;

public class GetProjectDescriptionAffectedEntities
extends MentionsGetAffectedEntitiesCommand {
    private final QueryDslAccessor db;
    private final DatabaseAccessor databaseAccessor;
    private final ApplicationProperties applicationProperties;

    public GetProjectDescriptionAffectedEntities(QueryDslAccessor db, DatabaseAccessor databaseAccessor, ApplicationProperties applicationProperties) {
        this.db = db;
        this.databaseAccessor = databaseAccessor;
        this.applicationProperties = applicationProperties;
    }

    @Override
    protected long getAffectedEntitiesCount(String likeQueryArgument) {
        if (!this.isWikiRenderingEnabled()) {
            return 0L;
        }
        return this.db.executeQuery(c -> ((SQLQuery)((SQLQuery)c.newSqlQuery().select(QProject.PROJECT.id).from((Expression)QProject.PROJECT)).where((Predicate)QueryDslUtils.safeContainsIgnoreCase(this.databaseAccessor.getDatabaseVendor(), QProject.PROJECT.description, likeQueryArgument))).fetchCount());
    }

    @Override
    protected String getDescriptionKey() {
        return "anonymization.username.project.description.mention.description";
    }

    private boolean isWikiRenderingEnabled() {
        return !this.applicationProperties.getOption("jira.project.description.html.enabled");
    }
}

