/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.operations;

import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AnonymizationParameters;
import com.atlassian.jira.user.anonymize.AnonymizeUserService;
import com.atlassian.jira.user.anonymize.BusinessLogicValidationResult;
import com.atlassian.jira.user.anonymize.OwnershipTransferParameter;
import com.atlassian.jira.user.anonymize.ServiceOutcomeWithWarnings;
import com.atlassian.jira.user.anonymize.ServiceResultWithWarnings;
import com.atlassian.jira.user.anonymize.UserPropertyChangeService;
import com.atlassian.jira.user.anonymize.operations.AnonymizeOperationStep;
import com.atlassian.jira.user.anonymize.operations.StepWithPluginPointInvocations;
import com.atlassian.jira.user.anonymize.ownership.OwnershipTransferChangeService;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferOwnershipPluginPointOperationStep
implements AnonymizeOperationStep,
StepWithPluginPointInvocations {
    private static final Logger log = LoggerFactory.getLogger(TransferOwnershipPluginPointOperationStep.class);
    private final OwnershipTransferChangeService ownershipTransferChangeService;
    private final I18nHelper.BeanFactory i18nBeanFactory;

    public TransferOwnershipPluginPointOperationStep(OwnershipTransferChangeService ownershipTransferChangeService, I18nHelper.BeanFactory i18nBeanFactory) {
        this.ownershipTransferChangeService = ownershipTransferChangeService;
        this.i18nBeanFactory = i18nBeanFactory;
    }

    @Override
    public Optional<AnonymizeUserService.SingleOperationReport<Void>> performOperation(@Nonnull AnonymizeUserService.OperationsReport<Void> anonymizeReport, @Nonnull AnonymizeUserService.AnonymizeValidationResult validationResult, @Nonnull Context asyncTaskContext) {
        if (!this.shouldPerformOperation(validationResult.getProcessData())) {
            log.info("Skipping transferring ownership in extension points");
            return Optional.empty();
        }
        Optional<OwnershipTransferParameter> ownershipTransferParameterOptional = this.getOwnershipTransferParameterForProcessData(validationResult.getProcessData(), asyncTaskContext);
        OwnershipTransferParameter ownershipTransferParameter = ownershipTransferParameterOptional.get();
        log.info("Transferring ownership in extension points for {}", (Object)ownershipTransferParameter);
        UserPropertyChangeService.UserPropertyChangeValidationResult<OwnershipTransferParameter> ownershipTransferValidationResult = this.ownershipTransferChangeService.validateUserPropertyChangeInOtherEntities(new UserPropertyChangeService.UserPropertyChangeRequest<OwnershipTransferParameter>(validationResult.getRequest().getExecutor(), ownershipTransferParameter));
        if (!ownershipTransferValidationResult.isValid()) {
            return Optional.of(new AnonymizeUserService.SingleOperationReport<Object>(AnonymizeUserService.AnonymizeOperation.USER_TRANSFER_OWNERSHIP_PLUGIN_POINTS, new ServiceOutcomeWithWarnings<Object>(null, ownershipTransferValidationResult.getErrorCollection(), new HashMap<String, ErrorCollection>())));
        }
        ServiceResultWithWarnings operationResult = this.ownershipTransferChangeService.userPropertyChangeInOtherEntities(ownershipTransferValidationResult);
        SimpleErrorCollection errors = new SimpleErrorCollection(operationResult.getErrorCollection());
        if (!operationResult.getWarnings().isEmpty()) {
            errors.addErrorMessage(this.i18nBeanFactory.getInstance(validationResult.getRequest().getExecutor()).getText("admin.errors.transfer.ownership.error.in.extension.point"));
        }
        return Optional.of(new AnonymizeUserService.SingleOperationReport<Object>(AnonymizeUserService.AnonymizeOperation.USER_TRANSFER_OWNERSHIP_PLUGIN_POINTS, new ServiceOutcomeWithWarnings<Object>(null, (ErrorCollection)errors, operationResult.getWarnings())));
    }

    @Override
    @Nonnull
    public ServiceOutcomeWithWarnings<Collection<AffectedEntity>> getAffectedEntities(AnonymizeUserService.AnonymizeProcessData anonymizationData) {
        OwnershipTransferParameter ownerTransferParameter = this.getOwnershipTransferParameterForAffectedEntities(anonymizationData);
        log.info("Getting transfer ownership affected entities for {}", (Object)ownerTransferParameter);
        AnonymizationParameters request = anonymizationData.getAnonymizationParameters();
        return this.ownershipTransferChangeService.getAffectedEntities(new UserPropertyChangeService.UserPropertyChangeRequest<OwnershipTransferParameter>(request.getExecutor(), ownerTransferParameter));
    }

    @Override
    @Nonnull
    public AnonymizeUserService.AnonymizeOperation getAnonymizeOperation() {
        return AnonymizeUserService.AnonymizeOperation.USER_TRANSFER_OWNERSHIP_PLUGIN_POINTS;
    }

    @Override
    @Nonnull
    public ServiceResult validate(@Nonnull AnonymizeUserService.AnonymizeProcessData anonymizationProcessData, I18nHelper i18nBean, boolean preValidate) {
        if (preValidate) {
            return ServiceOutcomeImpl.ok(null);
        }
        AnonymizationParameters request = anonymizationProcessData.getAnonymizationParameters();
        return this.ownershipTransferChangeService.validateUserPropertyChangeInOtherEntities(new UserPropertyChangeService.UserPropertyChangeRequest<OwnershipTransferParameter>(request.getExecutor(), new OwnershipTransferParameter(StringUtils.defaultString((String)request.getUserKey()), StringUtils.defaultString((String)request.getNewOwnerKey()), Contexts.nullContext())));
    }

    @Override
    public int getNumberOfTasks(@Nonnull AnonymizeUserService.AnonymizeValidationResult validationResult) {
        if (!validationResult.isValid()) {
            return 0;
        }
        Optional<OwnershipTransferParameter> ownershipTransferParameterOptional = this.getOwnershipTransferParameterForProcessData(validationResult.getProcessData(), Contexts.nullContext());
        return ownershipTransferParameterOptional.map(this.ownershipTransferChangeService::getNumberOfTasks).orElse(0);
    }

    @Override
    @Nonnull
    public BusinessLogicValidationResult validateBusinessLogic(@Nonnull AnonymizationParameters anonymizationParameters) {
        return this.ownershipTransferChangeService.validateBusinessLogic(anonymizationParameters);
    }

    @Nonnull
    private Optional<OwnershipTransferParameter> getOwnershipTransferParameterForProcessData(AnonymizeUserService.AnonymizeProcessData anonymizationProcessData, @Nonnull Context asyncTaskContext) {
        AnonymizationParameters request = anonymizationProcessData.getAnonymizationParameters();
        if (!StringUtils.isBlank((CharSequence)request.getNewOwnerKey())) {
            return Optional.of(new OwnershipTransferParameter(request.getUserKey(), request.getNewOwnerKey(), asyncTaskContext));
        }
        return Optional.empty();
    }

    @Nonnull
    private OwnershipTransferParameter getOwnershipTransferParameterForAffectedEntities(AnonymizeUserService.AnonymizeProcessData anonymizationProcessData) {
        return this.getOwnershipTransferParameterForProcessData(anonymizationProcessData, Contexts.nullContext()).orElseGet(() -> new OwnershipTransferParameter(anonymizationProcessData.getAnonymizationParameters().getUserKey(), anonymizationProcessData.getAnonymizationParameters().getUserKey(), Contexts.nullContext()));
    }
}

