/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.util;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.validation.Failure;
import com.atlassian.validation.Success;
import com.atlassian.validation.Validator;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

public class DuplicatedUsersPropertyValidator
implements Validator {
    private static final String OPTION_REGEX = "^$|^[^&]+(&[^&]+)*$";

    @Override
    public Validator.Result validate(String value) {
        UserManager userManager = ComponentAccessor.getUserManager();
        if (!value.matches(OPTION_REGEX)) {
            return new Failure("Bad option formatting, should be 'user1&user2&user3...' without an ampersand at the end.");
        }
        if (value.contains("<") || value.contains(">")) {
            return new Failure("Invalid character used: '>' or '<'");
        }
        if (value.trim().isEmpty()) {
            return new Success(value);
        }
        String[] usernames = value.split("&");
        Set invalidUsernames = Arrays.stream(usernames).filter(username -> userManager.getUserByName(username) == null).collect(Collectors.toSet());
        if (!invalidUsernames.isEmpty()) {
            String message = invalidUsernames.size() > 1 ? "Users: '" + String.join((CharSequence)"', '", invalidUsernames) + "' do not exist." : "User '" + invalidUsernames.stream().findFirst().orElse("unknown") + "' does not exist.";
            return new Failure(message);
        }
        return new Success(value);
    }
}

