/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.util;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.crowd.embedded.ofbiz.UserOrGroupStub;
import com.atlassian.jira.user.util.DuplicatedUsersToDirectoriesMapping;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicatedUsersService {
    private static final Logger LOG = LoggerFactory.getLogger(DuplicatedUsersService.class);
    private final CrowdDirectoryService crowdDirectoryService;
    private final DirectoryManager directoryManager;
    private final ApplicationProperties applicationProperties;

    public DuplicatedUsersService(CrowdDirectoryService crowdDirectoryService, DirectoryManager directoryManager, ApplicationProperties applicationProperties) {
        this.crowdDirectoryService = crowdDirectoryService;
        this.directoryManager = directoryManager;
        this.applicationProperties = applicationProperties;
    }

    public DuplicatedUsersToDirectoriesMapping getDuplicatedUsersMapping() {
        List userDirectories = this.crowdDirectoryService.findAllDirectories();
        if (userDirectories.size() > 1) {
            return this.getDuplicatedUsersMappingInternal(userDirectories);
        }
        return DuplicatedUsersToDirectoriesMapping.EMPTY;
    }

    private DuplicatedUsersToDirectoriesMapping getDuplicatedUsersMappingInternal(List<Directory> userDirectories) {
        DuplicatedUsersToDirectoriesMapping.Builder userToDirectoriesBuilder = new DuplicatedUsersToDirectoriesMapping.Builder();
        Set<String> explicitlyDuplicatedUsernames = this.getAllowedDuplicatedUsers();
        userDirectories.stream().filter(Directory::isActive).forEach(directory -> this.getAllUsersFromDirectory((Directory)directory).stream().filter(user -> !explicitlyDuplicatedUsernames.contains(this.getLowercaseUsername((User)user))).forEach(user -> userToDirectoriesBuilder.addDirectoryForUser(this.getLowercaseUsername((User)user), directory, user.isActive())));
        return userToDirectoriesBuilder.buildDuplicatedUsers();
    }

    private Set<String> getAllowedDuplicatedUsers() {
        return Arrays.stream(this.applicationProperties.getDefaultBackedString("jira.security.duplicated.user.accounts").split("&")).map(IdentifierUtils::toLowerCase).collect(Collectors.toSet());
    }

    private String getLowercaseUsername(User user) {
        return user instanceof UserOrGroupStub ? ((UserOrGroupStub)user).getLowerName() : IdentifierUtils.toLowerCase((String)user.getName());
    }

    private List<User> getAllUsersFromDirectory(Directory directory) {
        try {
            return this.directoryManager.searchUsers(directory.getId().longValue(), (EntityQuery)new UserQuery(User.class, (SearchRestriction)NullRestrictionImpl.INSTANCE, 0, -1));
        }
        catch (DirectoryNotFoundException e) {
            LOG.warn("Trying to get users from not existing directory.");
            return ImmutableList.of();
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }
}

