/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.compression;

import com.atlassian.jira.util.compression.ArchiveCompressor;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractArchiveCompressor
implements ArchiveCompressor {
    private static final Logger log = LoggerFactory.getLogger(AbstractArchiveCompressor.class);
    final ArchiveOutputStream archiveOutputStream;

    AbstractArchiveCompressor(ArchiveOutputStream archiveOutputStream) {
        this.archiveOutputStream = archiveOutputStream;
        log.debug("Opening archive compressor");
    }

    abstract ArchiveEntry createArchiveEntry(File var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFile(File file, File parentFile) throws IOException {
        Preconditions.checkArgument((!file.isDirectory() ? 1 : 0) != 0, (Object)"file should be a file");
        Preconditions.checkArgument((boolean)parentFile.isDirectory(), (Object)"parent path should be a directory");
        Path filepath = Paths.get(file.toString(), new String[0]);
        Path parentPath = Paths.get(parentFile.toString(), new String[0]);
        Preconditions.checkArgument((boolean)filepath.startsWith(parentPath), (Object)"parent path should be parent directory for file path");
        log.debug("Start adding file for archive compressor: {} in {}", (Object)file.getPath(), (Object)parentFile.getPath());
        String name = parentPath.relativize(filepath).toString();
        ArchiveEntry archiveEntry = this.createArchiveEntry(file, name);
        this.archiveOutputStream.putArchiveEntry(archiveEntry);
        try (FileInputStream input = new FileInputStream(file);){
            IOUtils.copyLarge((InputStream)input, (OutputStream)this.archiveOutputStream);
        }
        finally {
            this.archiveOutputStream.closeArchiveEntry();
        }
        log.debug("Done adding file for archive compressor: {} in {}", (Object)file.getPath(), (Object)parentFile.getPath());
    }

    @Override
    public void close() throws IOException {
        log.debug("Closing archive compressor");
        this.archiveOutputStream.finish();
        this.archiveOutputStream.close();
    }
}

