/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.stats;

import com.atlassian.jira.util.stats.SerializableStats;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class GsonStatsSerializer<T> {
    private static final String META_PREFIX = "_";

    public String serialize(T stats) {
        return this.serialize((Map<String, Object>)ImmutableMap.of(), stats);
    }

    public String serialize(Map<String, Object> metadata, T stats) {
        metadata.keySet().forEach(k -> Preconditions.checkArgument((boolean)k.startsWith(META_PREFIX)));
        Gson gson = this.buildGson();
        JsonObject jsonWithMeta = new JsonObject();
        metadata.forEach((k, v) -> jsonWithMeta.add(k, gson.toJsonTree(v)));
        gson.toJsonTree(stats).getAsJsonObject().entrySet().forEach(statsJsonElement -> jsonWithMeta.add((String)statsJsonElement.getKey(), (JsonElement)statsJsonElement.getValue()));
        return gson.toJson((JsonElement)jsonWithMeta);
    }

    public Map deserializeToMap(String statsJson) {
        Gson gson = this.buildGson();
        return (Map)gson.fromJson(statsJson, Map.class);
    }

    private Gson buildGson() {
        return new GsonBuilder().registerTypeHierarchyAdapter(SerializableStats.class, (src, typeOfSrc, context) -> context.serialize(src.getValueForSerialization())).registerTypeHierarchyAdapter(AtomicLong.class, (src, typeOfSrc, context) -> context.serialize((Object)src.get())).create();
    }
}

