/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.stats;

import com.atlassian.jira.util.stats.LongStats;
import com.atlassian.jira.util.stats.SerializableStats;
import com.google.common.collect.ImmutableSortedMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongConsumer;

public class MutableLongStats
implements LongConsumer,
SerializableStats<LongStats> {
    static final long MIN_UNSET = Long.MAX_VALUE;
    static final long MAX_UNSET = Long.MIN_VALUE;
    final AtomicLong count = new AtomicLong(0L);
    final AtomicLong min = new AtomicLong(Long.MAX_VALUE);
    final AtomicLong max = new AtomicLong(Long.MIN_VALUE);
    final AtomicLong sum = new AtomicLong(0L);
    final ImmutableSortedMap<Long, AtomicLong> distributionStats;

    public MutableLongStats(long ... distribution) {
        ImmutableSortedMap.Builder mutableDistributionStats = ImmutableSortedMap.naturalOrder();
        if (distribution.length > 0) {
            for (long d : distribution) {
                mutableDistributionStats.put((Object)d, (Object)new AtomicLong());
            }
            mutableDistributionStats.put((Object)Long.MAX_VALUE, (Object)new AtomicLong());
        }
        this.distributionStats = mutableDistributionStats.build();
        this.reset();
    }

    @Override
    public void accept(long value) {
        this.count.incrementAndGet();
        this.min.updateAndGet(currentMin -> value < currentMin ? value : currentMin);
        this.max.updateAndGet(currentMax -> value > currentMax ? value : currentMax);
        this.sum.addAndGet(value);
        if (!this.distributionStats.isEmpty()) {
            ((AtomicLong)this.distributionStats.ceilingEntry((Object)value).getValue()).incrementAndGet();
        }
    }

    public LongStats get() {
        return LongStats.create(this);
    }

    @Override
    public LongStats getValueForSerialization() {
        return this.get();
    }

    public void reset() {
        this.count.set(0L);
        this.min.set(Long.MAX_VALUE);
        this.max.set(Long.MIN_VALUE);
        this.sum.set(0L);
        this.distributionStats.forEach((distribution, stats) -> stats.set(0L));
    }

    public void merge(LongStats longStats) {
        this.count.addAndGet(longStats.count);
        this.min.updateAndGet(currentValue -> longStats.min < currentValue ? longStats.min : currentValue);
        this.max.updateAndGet(currentValue -> longStats.max > currentValue ? longStats.max : currentValue);
        this.sum.addAndGet(longStats.sum);
        this.distributionStats.forEach((distributionKey, distributionValue) -> distributionValue.addAndGet((Long)longStats.distributionCounter.getOrDefault(distributionKey, (Object)0L)));
    }
}

