/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.versioning;

import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.transaction.TransactionSupport;
import com.atlassian.jira.util.thread.JiraThreadLocalUtils;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TransactionSupportHelper {
    static final String POOL_SIZE_KEY = "com.atlassian.jira.versioning.required-new-transaction-pool-size";
    private static final Logger log = LoggerFactory.getLogger(TransactionSupportHelper.class);
    private final ExecutorService requiredNewExecutor;
    private final TransactionSupport transactionSupport;

    TransactionSupportHelper(TransactionSupport transactionSupport) {
        this.transactionSupport = transactionSupport;
        this.requiredNewExecutor = TransactionSupportHelper.createPool();
    }

    <V> V execute(Supplier<V> supplier) {
        return this.executeWithRequired(supplier);
    }

    <V> V executeWithRequired(Supplier<V> supplier) {
        return this.transactionSupport.execute(supplier);
    }

    <V> V executeWithRequiredNew(Supplier<V> supplier) {
        Future<Object> future = this.requiredNewExecutor.submit(JiraThreadLocalUtils.wrap(() -> this.transactionSupport.execute(supplier)));
        return (V)Futures.getUnchecked(future);
    }

    void executeWithRequiredNew(Runnable runnable) {
        this.executeWithRequiredNew(() -> {
            runnable.run();
            return null;
        });
    }

    void shutdown() {
        log.info("[VERSIONING] Shutting down required-new-transaction pool");
        this.requiredNewExecutor.shutdown();
        try {
            this.requiredNewExecutor.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static ExecutorService createPool() {
        int poolSize = JiraSystemProperties.getInstance().getInteger(POOL_SIZE_KEY, Integer.valueOf(50));
        log.info("[VERSIONING] creating pool of size: {} for running required-new-transaction to be used by versioning.", (Object)poolSize);
        return Executors.newFixedThreadPool(poolSize, new ThreadFactoryBuilder().setNameFormat("required-new-transaction-%d").setDaemon(true).build());
    }
}

