/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action;

import com.atlassian.http.url.SameOrigin;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.action.RedirectSanitiser;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectSanitiserImpl
implements RedirectSanitiser {
    private static final Logger securityLog = LoggerFactory.getLogger((String)"com.atlassian.jira.login.security");
    private static final Pattern ACCEPTABLE_RELATIVE_URL = Pattern.compile("^((\\.{1,2}/)*|/?)[^./]");
    private final VelocityRequestContextFactory velocityRequestContextFactory;

    public RedirectSanitiserImpl(VelocityRequestContextFactory velocityRequestContextFactory) {
        this.velocityRequestContextFactory = velocityRequestContextFactory;
    }

    public boolean canRedirectTo(@Nullable String redirectUri) {
        if (redirectUri == null) {
            return true;
        }
        try {
            URI uri = new URI(redirectUri);
            Matcher matcher = ACCEPTABLE_RELATIVE_URL.matcher(redirectUri);
            if (!uri.isAbsolute() && !matcher.find()) {
                return false;
            }
            if (this.getCanonicalBaseURL() == null) {
                return !uri.isAbsolute();
            }
            URI baseUrl = new URI(this.getCanonicalBaseURL());
            if (uri.isAbsolute() && !SameOrigin.isSameOrigin((URI)uri, (URI)baseUrl)) {
                return false;
            }
            return uri.getPath() == null || !uri.getPath().contains(":");
        }
        catch (MalformedURLException | URISyntaxException e) {
            return false;
        }
    }

    @Nullable
    public String makeSafeRedirectUrl(@Nullable String redirectUrl) {
        if (redirectUrl == null) {
            return null;
        }
        if (!this.canRedirectTo(redirectUrl)) {
            securityLog.warn("Potential malicious redirect detected: '{}'", (Object)redirectUrl);
            return null;
        }
        return redirectUrl;
    }

    protected String getCanonicalBaseURL() {
        return this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl();
    }
}

