/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.core.ofbiz.util.OFBizPropertyUtils;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.startup.PluginInfo;
import com.atlassian.jira.startup.PluginInfoProvider;
import com.atlassian.jira.startup.PluginInfos;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.system.ExtendedSystemInfoUtils;
import com.atlassian.jira.util.system.ExtendedSystemInfoUtilsImpl;
import com.atlassian.jira.util.system.check.SystemEnvironmentChecklist;
import com.atlassian.jira.util.system.patch.AppliedPatchInfo;
import com.atlassian.jira.util.system.patch.AppliedPatches;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.ofbiz.core.entity.GenericValue;

@WebSudoRequired
public class ViewSystemInfo
extends JiraWebActionSupport {
    private final ExtendedSystemInfoUtils extendedSystemInfoUtils;
    private List<String> warningMessages;
    private final LocaleManager localeManager;
    private final PluginInfoProvider pluginInfoProvider;
    private final FeatureManager featureManager;

    public ViewSystemInfo(LocaleManager localeManager, PluginInfoProvider pluginInfoProvider, FeatureManager featureManager) {
        this.localeManager = localeManager;
        this.pluginInfoProvider = pluginInfoProvider;
        this.featureManager = featureManager;
        this.extendedSystemInfoUtils = new ExtendedSystemInfoUtilsImpl((I18nHelper)this);
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        return super.doExecute();
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    public String doGarbageCollection() {
        System.gc();
        return "success";
    }

    public ExtendedSystemInfoUtils getExtendedSystemInfoUtils() {
        return this.extendedSystemInfoUtils;
    }

    public LocaleManager getLocaleManager() {
        return this.localeManager;
    }

    public List<String> getWarningMessages() {
        if (this.warningMessages == null) {
            this.warningMessages = SystemEnvironmentChecklist.getWarningMessages(this.getLocale(), true);
        }
        return this.warningMessages;
    }

    public String getDisplayNameOfLocale(Locale locale) {
        return locale.getDisplayName(this.getLocale());
    }

    public Map getApplicationPropertiesHTML() {
        return this.extendedSystemInfoUtils.getApplicationPropertiesFormatted("<br>");
    }

    public Map getSystemPropertiesHTML() {
        return this.extendedSystemInfoUtils.getSystemPropertiesFormatted("<br>");
    }

    public Set<AppliedPatchInfo> getAppliedPatches() {
        return AppliedPatches.getAppliedPatches();
    }

    public PluginInfos getUserPlugins() {
        return this.pluginInfoProvider.getUserPlugins();
    }

    public Iterator<PluginInfo> getSystemPlugins() {
        return this.pluginInfoProvider.getSystemPlugins().iterator();
    }

    public PropertySet getPropertySet(GenericValue gv) {
        return OFBizPropertyUtils.getPropertySet(gv);
    }
}

