/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.customfields;

import com.atlassian.jira.bc.customfield.CustomFieldService;
import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItem;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemService;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ObjectUtils;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.List;

@WebSudoRequired
public class EditCustomField
extends JiraWebActionSupport {
    private Long id;
    private String name;
    private String description;
    private String searcher;
    private final CustomFieldManager customFieldManager;
    private final CustomFieldService customFieldService;
    private final ReindexMessageManager reindexMessageManager;
    private final ManagedConfigurationItemService managedConfigurationItemService;

    public EditCustomField(CustomFieldService customFieldService, CustomFieldManager customFieldManager, ReindexMessageManager reindexMessageManager, ManagedConfigurationItemService managedConfigurationItemService) {
        this.customFieldService = customFieldService;
        this.customFieldManager = customFieldManager;
        this.managedConfigurationItemService = managedConfigurationItemService;
        this.reindexMessageManager = (ReindexMessageManager)Assertions.notNull((String)"reindexMessageManager", (Object)reindexMessageManager);
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        if (!this.validateFieldLocked()) {
            return "error";
        }
        this.setName(this.getCustomField().getUntranslatedName());
        this.setDescription(this.getCustomField().getUntranslatedDescription());
        CustomFieldSearcher currentSearcher = this.getCurrentSearcher();
        this.setSearcher(currentSearcher != null ? currentSearcher.getDescriptor().getCompleteKey() : null);
        return "input";
    }

    protected void doValidation() {
        if (!this.validateFieldLocked()) {
            return;
        }
        this.customFieldService.validateUpdate(this.getJiraServiceContext(), this.id, this.name, this.description, this.searcher);
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        CustomFieldSearcher newSearcher;
        CustomFieldSearcher oldSearcher = this.getCustomField().getCustomFieldSearcher();
        if (ObjectUtils.isValueSelected((Object)this.searcher)) {
            newSearcher = this.customFieldManager.getCustomFieldSearcher(this.searcher);
            if (oldSearcher == null || !oldSearcher.getDescriptor().getCompleteKey().equals(newSearcher.getDescriptor().getCompleteKey())) {
                this.reindexMessageManager.pushMessage(this.getLoggedInUser(), "admin.notifications.task.custom.fields");
            }
        } else {
            newSearcher = null;
        }
        this.customFieldManager.updateCustomField(this.getId(), this.getName(), this.getDescription(), newSearcher);
        return this.getRedirect("ViewCustomFields.jspa");
    }

    public boolean isFieldManaged() {
        return this.getManagedConfigurationEntity().isManaged();
    }

    public boolean isFieldLocked() {
        return !this.managedConfigurationItemService.doesUserHavePermission(this.getLoggedInUser(), this.getManagedConfigurationEntity());
    }

    public String getManagedFieldDescriptionKey() {
        return this.getManagedConfigurationEntity().getDescriptionI18nKey();
    }

    private boolean validateFieldLocked() {
        if (this.isFieldLocked()) {
            this.addErrorMessage(this.getText("admin.managed.configuration.items.customfield.error.cannot.edit.locked", this.getCustomField().getName()));
            return false;
        }
        return true;
    }

    private ManagedConfigurationItem getManagedConfigurationEntity() {
        CustomField customField = this.getCustomField();
        if (customField == null) {
            return null;
        }
        return this.managedConfigurationItemService.getManagedCustomField(customField);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long l) {
        this.id = l;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setSearcher(String searcher) {
        this.searcher = searcher;
    }

    public String getSearcher() {
        return this.searcher;
    }

    public List getSearchers() {
        return this.customFieldManager.getCustomFieldSearchers(this.customFieldManager.getCustomFieldObject(this.getId()).getCustomFieldType());
    }

    public CustomFieldSearcher getCurrentSearcher() {
        return this.getCustomField().getCustomFieldSearcher();
    }

    public CustomField getCustomField() {
        return this.customFieldManager.getCustomFieldObject(this.getId());
    }
}

