/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.customfields;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItem;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemService;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.MultipleSettableCustomFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.admin.translation.TranslationManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@WebSudoRequired
public class ViewCustomFields
extends JiraWebActionSupport {
    private final CustomFieldManager customFieldManager;
    private final FieldScreenManager fieldScreenManager;
    private final ManagedConfigurationItemService managedConfigurationItemService;
    private final TranslationManager translationManager;
    protected final PageBuilderService pageBuilder;
    protected final FeatureManager featureManager;
    private Map fieldScreenTabMap;

    public ViewCustomFields(CustomFieldManager customFieldManager, FieldScreenManager fieldScreenManager, ManagedConfigurationItemService managedConfigurationItemService, TranslationManager translationManager, PageBuilderService pageBuilder, FeatureManager featureManager) {
        this.customFieldManager = customFieldManager;
        this.fieldScreenManager = fieldScreenManager;
        this.managedConfigurationItemService = managedConfigurationItemService;
        this.translationManager = translationManager;
        this.pageBuilder = pageBuilder;
        this.featureManager = featureManager;
        this.fieldScreenTabMap = new HashMap();
    }

    private void processResources() {
        this.pageBuilder.assembler().resources().requireWebResource("jira.webresources:viewcustomfields").requireContext("atl.admin.custom-fields");
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doExecute() throws Exception {
        if (this.featureManager.isEnabled(JiraFeatureFlagRegistrar.CUSTOMFIELDS_REDESIGN)) {
            this.processResources();
            return "super-success";
        }
        return super.doExecute();
    }

    @SupportedMethods(value={RequestMethod.POST})
    public String doReset() throws Exception {
        this.customFieldManager.refresh();
        return super.doDefault();
    }

    public List<CustomField> getCustomFields() {
        return this.customFieldManager.getCustomFieldObjects();
    }

    @ActionViewData
    public boolean isCustomFieldTypesExist() {
        List fieldTypes = this.customFieldManager.getCustomFieldTypes();
        return !fieldTypes.isEmpty();
    }

    public boolean isHasConfigurableOptions(CustomField customField) {
        return customField.getCustomFieldType() instanceof MultipleSettableCustomFieldType;
    }

    public Collection getFieldScreenTabs(OrderableField orderableField) {
        String fieldId = orderableField.getId();
        if (!this.fieldScreenTabMap.containsKey(fieldId)) {
            this.fieldScreenTabMap.put(fieldId, this.fieldScreenManager.getFieldScreenTabs(orderableField.getId()));
        }
        return (Collection)this.fieldScreenTabMap.get(fieldId);
    }

    public boolean isFieldManaged(CustomField field) {
        ManagedConfigurationItem item = this.managedConfigurationItemService.getManagedCustomField(field);
        return item.isManaged();
    }

    @ActionViewData
    public boolean isMultiLingual() {
        Map installedLocales = this.translationManager.getInstalledLocales();
        return installedLocales.size() > 1;
    }

    public boolean isFieldLocked(CustomField field) {
        ManagedConfigurationItem item = this.managedConfigurationItemService.getManagedCustomField(field);
        if (!item.isManaged()) {
            return false;
        }
        return !this.managedConfigurationItemService.doesUserHavePermission(this.getLoggedInUser(), item);
    }

    public String getManagedFieldDescriptionKey(CustomField field) {
        ManagedConfigurationItem item = this.managedConfigurationItemService.getManagedCustomField(field);
        String descriptionI18nKey = item.getDescriptionI18nKey();
        if (StringUtils.isBlank((CharSequence)descriptionI18nKey)) {
            return "";
        }
        return descriptionI18nKey;
    }
}

