/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.filters;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.filter.FilterDeletionWarningViewProvider;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.sharing.type.ShareTypeFactory;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jira.web.action.filter.FilterOperationsAction;
import com.atlassian.jira.web.action.filter.FilterOperationsBean;
import com.atlassian.jira.web.action.filter.FilterViewHelper;
import com.atlassian.jira.web.action.filter.ManageFilters;
import com.atlassian.jira.web.action.filter.SharedFilterAdministrationViewHelper;
import com.atlassian.jira.web.action.util.SearchRequestDisplayBean;
import com.atlassian.jira.web.action.util.sharing.SharedEntitySearchAction;
import com.atlassian.jira.web.action.util.sharing.SharedEntitySearchViewHelper;
import com.atlassian.jira.web.ui.model.DropDownModel;
import com.atlassian.jira.web.ui.model.DropDownModelBuilder;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import javax.servlet.http.HttpServletRequest;
import webwork.action.ActionContext;

@WebSudoRequired
public class ViewSharedFilters
extends ManageFilters
implements FilterOperationsAction,
SharedEntitySearchAction {
    private static final String OWNER = "filters.searchOwnerUserName";
    private static final String NAME = "filters.searchName";
    private final FilterViewHelper filterViewHelper;
    private final FeatureManager featureManager;
    private boolean useParentSearch = true;
    private boolean searchPerformed = false;

    public ViewSharedFilters(JiraAuthenticationContext authCtx, IssueSearcherManager issueSearcherManager, SearchRequestService searchRequestService, ShareTypeFactory shareTypeFactory, SearchRequestDisplayBean.Factory beanFactory, SearchService searchService, PageBuilderService pageBuilderService, FilterDeletionWarningViewProvider filterDeletionWarningViewProvider, UserPreferencesManager userPreferencesManager, FeatureManager featureManager, UserManager userManager, GlobalPermissionManager permissionManager) {
        super(authCtx, issueSearcherManager, searchRequestService, shareTypeFactory, beanFactory, searchService, pageBuilderService, filterDeletionWarningViewProvider, userPreferencesManager, featureManager, userManager, permissionManager);
        this.filterViewHelper = new SharedFilterAdministrationViewHelper(shareTypeFactory, authCtx, ActionContext.getRequest().getContextPath(), "ViewSharedFilters.jspa", searchRequestService, featureManager, userManager, permissionManager);
        this.featureManager = featureManager;
    }

    @Override
    public DropDownModel getDropDownModel(SearchRequestDisplayBean displayBean, int listIndex) {
        DropDownModelBuilder builder = DropDownModelBuilder.builder();
        builder.setTopText(this.getText("common.words.operations"));
        builder.startSection().addItem(builder.item().setText(this.getText("sharedfilters.admin.cog.changeowner")).setAttr("id", "change_owner_" + displayBean.getId()).setAttr("class", "change-owner").setAttr("href", this.toUrl(displayBean, "ChangeSharedFilterOwner!default.jspa", true) + this.buildQueryStringForModel(ExecutingHttpRequest.get())).setAttr("rel", "" + displayBean.getId())).addItem(builder.item().setText(this.getText("sharedfilters.delete")).setAttr("id", "delete_" + displayBean.getId()).setAttr("class", "delete-filter").setAttr("href", this.toUrl(displayBean, "DeleteSharedFilter!default.jspa", true) + this.buildQueryStringForModel(ExecutingHttpRequest.get())).setAttr("rel", "" + displayBean.getId()));
        builder.endSection();
        return builder.build();
    }

    private String buildQueryStringForModel(HttpServletRequest request) {
        StringBuilder builder = new StringBuilder("");
        if (request.getMethod().equalsIgnoreCase("POST")) {
            this.appendParameter(builder, "searchOwnerUserName", this.getSearchOwnerUserName());
            this.appendParameter(builder, "searchName", this.getSearchName());
        } else if (request.getQueryString() != null) {
            builder.append("&");
            builder.append(request.getQueryString());
        }
        this.appendParameter(builder, "totalResultCount", "" + this.getTotalResultCount());
        return builder.toString();
    }

    private StringBuilder appendParameter(StringBuilder builder, String param, String value) {
        return builder.append("&").append(param).append("=").append(JiraUrlCodec.encode((String)value));
    }

    @Override
    protected FilterViewHelper getFilterHelper() {
        return this.filterViewHelper;
    }

    public String doDefault() throws Exception {
        return super.doDefault();
    }

    protected void doValidation() {
        super.doValidation();
    }

    @Override
    @SupportedMethods(value={RequestMethod.GET, RequestMethod.POST})
    protected String doExecute() {
        this.useParentSearch = true;
        this.setReturnUrl(String.format("ViewSharedFilters.jspa", new Object[0]));
        ActionContext.getSession().put(OWNER, this.getSearchOwnerUserName());
        ActionContext.getSession().put(NAME, this.getSearchName());
        this.requireDeleteDialogResources();
        return this.executeSearch();
    }

    @Override
    public FilterOperationsBean getFilterOperationsBean() {
        return super.getFilterOperationsBean();
    }

    private String executeSearch() {
        this.searchPerformed = true;
        this.setReturnUrl(String.format("ViewSharedFilters.jspa", new Object[0]));
        JiraServiceContext ctx = this.getJiraServiceContext();
        SharedEntitySearchViewHelper.SearchResult<SearchRequest> searchResults = this.getFilterHelper().search(ctx);
        this.setSearchResults(searchResults);
        if (searchResults == null || ctx.getErrorCollection().hasAnyErrors()) {
            this.searchPerformed = false;
        } else {
            this.setFilters(this.beanFactory.createDisplayBeans(searchResults.getResults()));
        }
        return this.isContentOnly() ? "contentonly" : "success";
    }

    @Override
    public boolean isSearchRequested() {
        return this.useParentSearch ? super.isSearchRequested() : this.searchPerformed;
    }

    public boolean isManageAllFilters() {
        return this.featureManager.isEnabled(JiraFeatureFlagRegistrar.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
    }
}

