/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.enterprise;

import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemService;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.layout.field.EditableFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.web.action.admin.issuefields.AbstractEditFieldLayoutItem;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import org.ofbiz.core.entity.GenericValue;

@WebSudoRequired
public class EditFieldLayoutItem
extends AbstractEditFieldLayoutItem {
    private Long id;
    private EditableFieldLayout editableFieldLayout;
    private FieldLayoutManager fieldLayoutManager;

    public EditFieldLayoutItem(FieldLayoutManager fieldLayoutManager, FieldManager fieldManager, ManagedConfigurationItemService managedConfigurationItemService) {
        super(managedConfigurationItemService, fieldManager);
        this.fieldLayoutManager = fieldLayoutManager;
    }

    @Override
    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        this.doValidation();
        if (!this.invalidInput()) {
            return super.doDefault();
        }
        return "error";
    }

    @Override
    protected void doValidation() {
        if (this.getId() != null) {
            if (this.getFieldLayout() == null) {
                this.addErrorMessage(this.getText("admin.errors.fieldlayout.no.field.config.id"));
            } else {
                super.doValidation();
            }
        } else {
            this.addErrorMessage(this.getText("admin.errors.fieldlayout.no.field.config.id"));
        }
    }

    @Override
    protected String getRedirectURI() {
        return "ConfigureFieldLayout.jspa?id=" + this.getId();
    }

    @Override
    protected EditableFieldLayout getFieldLayout() {
        if (this.editableFieldLayout == null) {
            this.editableFieldLayout = this.getFieldLayoutManager().getEditableFieldLayout(this.getId());
        }
        return this.editableFieldLayout;
    }

    @Override
    protected void store() {
        try {
            this.getFieldLayoutManager().storeEditableFieldLayout(this.getFieldLayout());
        }
        catch (DataAccessException e) {
            this.log.error((Object)"Error while accessing field layouts.", (Throwable)e);
            this.addErrorMessage("Error while accessing field layouts.");
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public FieldLayoutManager getFieldLayoutManager() {
        return this.fieldLayoutManager;
    }

    public GenericValue getFieldLayoutScheme(Long schemeId) {
        return null;
    }
}

